/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class GSCanvas
extends Canvas {
    GScroll boss;
    int value;
    int visible;
    int min;
    int max;
    int barwidth;
    int mode;
    Image offscreen = null;
    Dimension offscreensize;
    Graphics offgraphics;
    int busize;
    int barx;
    int tempvalue;
    boolean dragmode = false;

    public GSCanvas(GScroll gScroll, int n, int n2) {
        this.mode = n2;
        this.busize = n;
        this.boss = gScroll;
        this.min = 0;
        this.max = 0;
        this.value = 0;
        this.visible = 0;
        this.tempvalue = -1;
    }

    public Dimension getMinimumSize() {
        if (this.mode == 0) {
            return new Dimension(this.busize * 2, this.busize);
        }
        return new Dimension(this.busize, this.busize * 2);
    }

    public void setValues(int n, int n2, int n3, int n4) {
        this.min = n3;
        this.max = n4;
        this.value = n;
        this.visible = n2;
        if (this.value < this.min) {
            this.value = this.min;
        } else if (this.value > this.max) {
            this.value = this.max;
        }
        if (this.min == this.max) {
            this.max = this.min + 1;
        }
    }

    public void setChangeValue(int n) {
        this.value += n;
        if (this.value < this.min) {
            this.value = this.min;
        } else if (this.value > this.max) {
            this.value = this.max;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.offscreen == null || dimension.width != this.offscreensize.width || dimension.height != this.offscreensize.height) {
            this.offscreen = this.createImage(dimension.width, dimension.height);
            this.offscreensize = dimension;
            this.offgraphics = this.offscreen.getGraphics();
            this.offgraphics.setFont(this.getFont());
        }
        this.paintBar(this.offgraphics);
        if (this.dragmode && this.boss.getType() == 0) {
            this.paintTempBox(this.offgraphics);
        }
        graphics.drawImage(this.offscreen, 0, 0, null);
    }

    private void paintBar(Graphics graphics) {
        int n;
        Dimension dimension = this.getSize();
        if (this.boss.getType() == 0) {
            graphics.setColor(Color.darkGray);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        } else if (this.boss.getType() == 1) {
            graphics.setColor(Color.black);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(Color.darkGray);
            n = dimension.width / 3;
            graphics.fillRect(n, 0, n, dimension.height);
        }
        n = this.max - this.min;
        if (n <= 0) {
            n = 1;
        }
        int n2 = dimension.width;
        if (this.mode == 1) {
            n2 = dimension.height;
        }
        this.barwidth = (int)((double)n2 / (double)(n + this.visible) * (double)this.visible);
        if (this.barwidth < this.busize) {
            this.barwidth = this.busize;
        }
        this.barx = (int)((double)(this.value - this.min) / (double)n * (double)(n2 - this.barwidth));
        if (this.boss.getType() == 0) {
            graphics.setColor(Color.white);
        } else if (this.boss.getType() == 1) {
            graphics.setColor(Color.lightGray);
        }
        if (this.mode == 0) {
            graphics.fill3DRect(this.barx, 1, this.barwidth, dimension.height - 2, true);
        } else {
            graphics.fill3DRect(1, this.barx, dimension.width - 2, this.barwidth, true);
        }
    }

    private void paintTempBox(Graphics graphics) {
        graphics.setColor(Color.white);
        if (this.mode == 0) {
            graphics.draw3DRect(this.tempvalue, 1, this.barwidth, this.getSize().height - 2, true);
        } else {
            graphics.draw3DRect(1, this.tempvalue, this.getSize().width - 2, this.barwidth, true);
        }
    }

    public void confirmValue() {
        int n = this.getSize().width;
        if (this.mode == 1) {
            n = this.getSize().height;
        }
        double d = (double)this.tempvalue / (double)(n - this.barwidth) * (double)(this.max - this.min);
        this.value = (int)d + this.min;
    }

    public void setTempValue(int n) {
        this.tempvalue = n;
        int n2 = this.getSize().width - this.barwidth;
        if (this.mode == 1) {
            n2 = this.getSize().height - this.barwidth;
        }
        if (this.tempvalue < 0) {
            this.tempvalue = 0;
        } else if (this.tempvalue > n2) {
            this.tempvalue = n2;
        }
    }

    public void setDragMode(boolean bl) {
        this.dragmode = bl;
    }

    public boolean getDragMode() {
        return this.dragmode;
    }

    public boolean isOnMarker(int n) {
        return n > this.barx && n < this.barx + this.barwidth;
    }

    public void chgBlockValue(int n) {
        int n2 = this.visible / 2;
        if (n2 < 1) {
            n2 = 1;
        }
        if (n < this.barx) {
            n2 *= -1;
        }
        this.setChangeValue(n2);
    }

    public int getValue() {
        return this.value;
    }

    public int getBarX() {
        return this.barx;
    }
}

