
import com.apple.cocoa.foundation.*;
import com.apple.cocoa.application.*;
import java.io.*;
import java.util.*;
import java.text.*;

public class MyItem extends NSObject {

    private String path;
    private String shortPath;
    private NSDate modifiedDate;
    private NSMutableArray children;

    public MyItem() {
        super();
        this.path = new String("/");
        this.children = null;
        setModifiedDate();
    }
    
    public MyItem(String pathString){
        super();
        this.path = new String(pathString);
        this.children = null;   
        setModifiedDate(); 
    }
    private void setModifiedDate(){
        NSDictionary dict = NSPathUtilities.fileAttributes(path,true);
        if(dict == null) modifiedDate = new NSDate();
        else
            modifiedDate = new NSDate(0,(NSDate)dict.objectForKey("NSFileModificationDate"));
    }
    public boolean after(NSDate cdate){
        if(modifiedDate == null) return false;
        return after(modifiedDate,cdate);
    }


    public String path() {
        return this.path;
    }
    public String fileName(){
        return (NSPathUtilities.lastPathComponent(path)) ;
    }
    public String getShortPath(){return shortPath;}
    public void setShortPath(String _shortPath){
        shortPath = _shortPath;
    }
    public NSDate getModifiedDate(){return modifiedDate;}
    public String getModifiedDateString(){
//System.out.println("path = "+path);    
       /*SimpleDateFormat outformatter = 
	 		new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return(outformatter.format(modifiedDate));    */
       // return modifiedDate.toString();
        NSGregorianDateFormatter formatter = new NSGregorianDateFormatter("%Y/%m/%d %H:%M:%S",true);
        String str = "";
        try{
            str  = formatter.stringForObjectValue(modifiedDate);
        }
        catch(Exception e){}
        return str;
    }   
    public boolean isDirectory(){
        File fp = new File(path);
        return (fp.isDirectory());
    }
    public NSMutableArray children() {
        File item;
        String items[];
        int i = 0, cnt;
                
        if(this.children == null) {
            item = new File(path);
            
            if(item.isDirectory()) {                
                items = item.list();

                if(items == null) {
                    this.children = null;
                    return children;
                }
                else
                    cnt = items.length;
                
                this.children = new NSMutableArray();
                
                for( i = 0; i < cnt; i++){
                    String str = (String)items[i];
                    if(str.startsWith(".")) continue;
                    MyItem nitem = new MyItem(this.path+"/"+str);
                    children.addObject(nitem);
                }
            }
            else{
                this.children = null;
            }
   
        }
 
        return children;
    }
    
    private boolean after(NSDate dayOne, NSDate dayTwo){
        if(dayOne.timeIntervalSinceReferenceDate() > dayTwo.timeIntervalSinceReferenceDate()) return true;
	else return false;
    }
    public int compare(MyItem citem){
        return (citem.getModifiedDate()).compare(modifiedDate);
    }
    public void sortChildData(){
//System.out.println("sort called");
 
        if(children == null){
            this.children = children();
        }
        NSSelector selector = new NSSelector("compare",new Class[]{MyItem.class});
        children.sortUsingSelector(selector);        
    }
    
    public MyItem childAtIndex(int index) { 
        if(index >=numberOfChildren()) return null;
        else return ((MyItem)this.children().objectAtIndex(index));
    }
    
    public int numberOfChildren() {
        if(this.children() == null)
            return -1;
        else
            return this.children.count();
    }
	
	public Vector getAllChildren(){
		Vector ret = new Vector();
		getAllChildren(ret);
		return ret;
	}
	public void getAllChildren(Vector ret){
		File fp = new File(path);
		if(fp.isDirectory()){
			String[] items = fp.list();
			for( int i = 0; i < items.length; i++){
				String str = (String)items[i];
				if(str.startsWith(".")) continue;
				MyItem nitem = new MyItem(this.path+"/"+str);
				nitem.getAllChildren(ret);
			}
		}
		else{
			ret.add(this);
		}
	}
}
