/* GSettingControl */

import com.apple.cocoa.foundation.*;
import com.apple.cocoa.application.*;
import java.util.*;

public class GSettingControl {

    GBControl boss;// GBControl instance
    NSComboBox connectionName;
    NSTextField hostAddress;
    NSTextField localDir;
    NSSecureTextField password;
    NSTextField remoteDir;
    NSTextField userName;
   // NSTextField scanDateText;
    NSView myView;
    NSPopUpButton connectionMenu;// this is from main windows    
    Vector siteInfo;
    
    public void setSiteInfo(Vector _siteInfo){
        siteInfo = _siteInfo;
    }
    
    public  void drawerDidOpen(NSNotification notification){
         updateSetMenu(); 
 //System.out.println("updatemenu called");
        if(siteInfo.size() > 0){
            connectionName.selectItemAtIndex(connectionMenu.indexOfSelectedItem());
            connectionName.setObjectValue(connectionName.objectValueOfSelectedItem());
        }      
    }

    private void updateSetMenu(){ 
        connectionName.removeAllItems();
 //System.out.println(siteInfo);       
        for(int i = 0;i<siteInfo.size();i++){
            ConnectionInfo info = (ConnectionInfo)(siteInfo.elementAt(i));
            connectionName.addItemWithObjectValue(info.getSetName());
        }

    }

    //////////////////////////////////////////////////////////////////
    ///////Action from buttons
    //////////////////////////////////////////////////////////////////

    public void addEntry(Object sender){
    // confirm current data
        boolean newEntryFlag = false;
        String setNameString = getSetName();
        if(setNameString == null) return;
        ConnectionInfo info = getSetNameWithName(setNameString);
        if(info == null){
            info = new ConnectionInfo();
            info.setSetName(setNameString);
            siteInfo.addElement(info);
            connectionName.addItemWithObjectValue(setNameString);
            newEntryFlag = true;   
        }
        info.setHostAddress(hostAddress.stringValue());
        info.setUserName(userName.stringValue());
        info.setPassword(password.stringValue());
        info.setRemoteDir(remoteDir.stringValue());
        info.setLocalDir(localDir.stringValue());
        //info.setScanneDate((NSDate)scanndDateText.objectValue());
        (new FileAccessor()).fileOutSetting(siteInfo);
        if(newEntryFlag) boss.updateConnectionMenu();       
    }
            
    public void deleteSelected(Object sender){
    // delete button pushed. delete current setting
        String setNameString = getSetName();
        if(setNameString == null) return; 
        ConnectionInfo info = getSetNameWithName(setNameString);
        if(info != null){
            siteInfo.removeElement(info);
            updateSetMenu();
            boss.updateConnectionMenu();
        }   
        if(siteInfo.size() > 0){
            connectionName.selectItemAtIndex(0);
            connectionName.setObjectValue(connectionName.objectValueOfSelectedItem());
        }   
        (new FileAccessor()).fileOutSetting(siteInfo);                   
    }
    

    
    public void comboBoxSelectionIsChanging(NSNotification notification){
       // addEntry(null);
    }
    
    public  void comboBoxSelectionDidChange(NSNotification notification){
    
        connectionName.setObjectValue(connectionName.objectValueOfSelectedItem());
//System.out.println("setname = " + setName.stringValue());
        String setNameString = getSetName();

        if(setNameString == null){
            clearEntry();
            return;
        }
        ConnectionInfo info = getSetNameWithName(setNameString);
      
        if(info == null){
            clearEntry();
        }        
        else{     
            hostAddress.setStringValue(info.getHostAddress());
            userName.setStringValue(info.getUserName());
            password.setStringValue(info.getPassword());
            remoteDir.setStringValue(info.getRemoteDir());
            localDir.setStringValue(info.getLocalDir());
            //scanDateText.setObjectValue(info.getScannedDate());
//System.out.println((new NSDate()).toString());            
        }
    }
    private void clearEntry(){
            hostAddress.setStringValue("");
            userName.setStringValue("");
            password.setStringValue("");
            remoteDir.setStringValue("");
            localDir.setStringValue("");    
            //scanDateText.setStringValue("");
    }
    private String getSetName(){
	String _setName = connectionName.stringValue(); 
        if(_setName == null) return null;
        if(_setName.equals("")) return null;
        return _setName;   
    }
    
    private ConnectionInfo getSetNameWithName(String name){
        for(int i = 0;i<siteInfo.size();i++){
            ConnectionInfo info = (ConnectionInfo)(siteInfo.elementAt(i));
//System.out.println("seeking" + name + " " + (info.getHostAddress()));           
            if((info.getSetName()).equals(name)) return info;
        }
        return null;
    }
    
    /////////////////////////////////////////////////////////////////////////    
    //////// localDir select dialog related...
    /////////////////////////////////////////////////////////////////////////


    // pop up file selection dialog
    public void selectLocalDir(Object sender){
        NSOpenPanel panel = (NSOpenPanel.openPanel());
        panel.setCanChooseDirectories(true);
        panel.setCanChooseFiles(false);
        panel.setAllowsMultipleSelection(false);
        panel.setPrompt(NSBundle.mainBundle().localizedStringForKey("CFSelectFileButtonMessage","Select",null));
        int result = panel.runModalForTypes(null);
       // panel.runModalInDirectory(NSSystem.currentHomeDirectory(),null, null);
        if(result == NSPanel.OKButton){
            if(panel.filenames() == null) return;
            String filepath = (String)((panel.filenames()).objectAtIndex(0));
            if(filepath == null) return;
            localDir.setStringValue(filepath);
        }
        else if(result == NSPanel.CancelButton){}
    }


}
