//
//  GFTPControl.java
//  GFPut
//
//  Created by grgr56 on Mon Nov 26 2001.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//

import com.apple.cocoa.foundation.*;
import com.apple.cocoa.application.*;
import cz.dhl.io.*;
import cz.dhl.ftp.*;
import java.util.*;

public class GFTPControl extends Thread{

    
    GBControl boss;
    ConnectionInfo info;
    int transferMode;
    Vector transferFileNames;
    boolean interruptFlag;
    
    public GFTPControl(){
        transferFileNames = new Vector();
        interruptFlag = false;
    }
    
    public void setBoss(GBControl _boss){
        boss = _boss;
    }
    
    
    public void setInfo(ConnectionInfo _info, int _transferMode){
        info = _info;
        transferMode = _transferMode;
    }
    public synchronized void setInterrupt(boolean flag){
        interruptFlag = flag;
    }

    
    public void run() {
        getFilesToTransfer();
		ftp();
        boss.ftpFinished();
    }
    
//    public void runSync() {
//        getFilesToTransfer();
//	ftp();
//        boss.ftpFinished();
//    }
        
    private void getFilesToTransfer(){
        Vector fvect = boss.getFileToTransfer();
        for(int i = 0;i<fvect.size();i++){
            transferFileNames.addElement((MyItem)fvect.elementAt(i));
        }
    }
    private boolean connect(Ftp cl){
		try{
			 return cl.connect(info.getHostAddress(),Ftp.PORT);
		}
		catch(Exception e){

			return false;
		}
	}
	
	private boolean login(Ftp cl){
		boss.setFtpMessage("Logging in..");
		try{
			return cl.login(info.getUserName(), info.getPassword());
		}
		catch(Exception e){

			return false;
		}
	}
	
	private void setTransferMode(Ftp cl){
		//cl.setTransfer(FTP.TRANSFER_PASV);
		switch(transferMode){
			case 0:
				//
				//ftp.setMode(FTP.MODE_AUTO);
				break;
			case 1:
				cl.command("TYPE A");
				//ftp.setMode(FTP.MODE_ASCII);
				break;
			case 2:
				cl.command("TYPE I");
				//ftp.setMode(FTP.MODE_BINARY);
				break;
			default:
				break;
		}	
	}
	
	private void uploadFiles(Ftp cl){
		boss.setFtpMessage("Changing Directory..");
		boolean successFlag = true;
		for(int i=0;i<transferFileNames.size();i++){
            MyItem item = (MyItem)transferFileNames.elementAt(i);
            //boss.fileTransferStarted(item.path());
            
            boss.setFtpMessage("uploading "+(item.fileName())+"..");      
			
			/* to FtpFile remote file */
			CoFile to = new FtpFile(info.getRemoteFileName(item.path()),cl);

			CoFile from = new LocalFile(item.path());
//System.out.println(" to "+info.getRemoteFileName(item.path()));
//System.out.println(item.path());

			boolean uploadFlag = CoLoad.copy(to,from);

			if(!uploadFlag){
				for(int level=0;level<to.getPathDepth();level++){
					CoFile partpath = to.getPathFragment(level);
//System.out.println("check "+partpath.toString());					
					if(!partpath.exists()){
						partpath.mkdir();
					}
				}
				uploadFlag = CoLoad.copy(to,from);
			}
			if(uploadFlag){
				boss.fileTansferFinished(item.path());
			}
			else{
				successFlag = false;
			}
		}
		if(successFlag){
			boss.setFtpMessage("OK.");        		
		}
		else{
			boss.setFtpMessage("Error while uploading..");        
		}
	}
	
    public  void ftp()
    {
        if(transferFileNames.size() == 0) return;
        
        boss.setFtpMessage("Connecting to host..");
		Ftp cl = new Ftp();
		try{

			if(!connect(cl)){
//System.out.println("connection failreus")	;		
				boss.setFtpMessage("Connection failed.");
				throw(new Exception());
			}
			if(!login(cl)){
				boss.setFtpMessage("Login failed.");
				throw(new Exception());			
			}
			//setTransferMode(cl);
			
			uploadFiles(cl);
		}
		catch(Exception e){
			System.err.println(e);
		}
		finally { /* disconnect from server 
        	  * this must be always run */
			//boss.setFtpMessage("Disconnectiong...");
            cl.disconnect();
        }		

    }
    
}
