/* GDialogControl */

import com.apple.cocoa.foundation.*;
import com.apple.cocoa.application.*;
import java.util.*;

public class GDialogControl {

    NSPanel dialog;
    NSButton okButton;
    NSWindow mainWindow;
    NSTextField connectedDateText;
    GBControl boss;
    NSProgressIndicator progressBar;
        
    public void initialize(GBControl _boss){
        boss = _boss;
        NSButtonCell buttonCell = (NSButtonCell)okButton.cell();
        dialog.setDefaultButtonCell(buttonCell);
    }
    ///////////////////////////////////////////////
    //// Update File Scan related
    ///////////////////////////////////////////////  
    public void scanUpdateFile(Object sender){

        ConnectionInfo info = boss.getSelectedConnectionInfo();
        
        connectedDateText.setObjectValue(info.getConnectedDate());

        NSApplication app = NSApplication.sharedApplication();
        NSSelector selector = new NSSelector("acceptFromScanDialog",
            new Class[]{NSWindow.class,int.class,Object.class});
     
        app.beginSheet(dialog,mainWindow,this,selector,null);
    }
    public void okAction(Object sender){
        NSDate connectedDate = (NSDate)connectedDateText.objectValue();
//System.out.println(connectedDate.toString());        
        closeDialog();

        (mainWindow.contentView()).addSubview(progressBar);
        ConnectionInfo info = boss.getSelectedConnectionInfo();
        MyItem root  = new MyItem(info.getLocalDir());
        Vector lvect = new Vector();
        scanUpdatedFile(lvect,connectedDate,root);
        for(int i = 0;i<lvect.size();i++){
            MyItem item = (MyItem)(lvect.elementAt(i));
            //System.out.println(item.fileName());
            boss.addFileToList(item);
            progressBar.animate(this);
            //progressBar.setDoubleValue(100.0*(double)(i/(double)(lvect.size())));
            progressBar.displayIfNeeded();
        }
        //progressBar.stopAnimation(this);
        //progressBar.setDoubleValue(0.0);
        progressBar.removeFromSuperview();        
    }
    public void cancelAction(Object sender){
        closeDialog();
    }
    private void closeDialog(){
        dialog.orderOut(this);
        NSApplication.sharedApplication().endSheet(dialog);    
    }
    public void acceptFromScanDialog(NSWindow sheet, int returncode,Object contextInfo){
        //System.out.println(returncode);
    }

    private void scanUpdatedFile(Vector vect,NSDate date,MyItem root){
        NSMutableArray childList = root.children();
        java.util.Enumeration enumerator = childList.objectEnumerator();

        while (enumerator.hasMoreElements()) {
            MyItem citem = (MyItem)enumerator.nextElement(); 
            if(citem.isDirectory()){
                scanUpdatedFile(vect,date,citem);
            }
            else{
                if(citem.after(date)){
                    vect.addElement(citem);
                }
            }
        }
    }
}
