/* GBControl */

import com.apple.cocoa.foundation.*;
import com.apple.cocoa.application.*;
import java.util.*;
import java.io.*;
import java.net.*;

public class GBControl {

 //   GModeControl gmcnt;			//controler of mode setting
    GDialogControl gdcnt;		// controler of scan dialog
    GSettingControl gscnt;		// controler of connection sets
    GFTPControl gfcnt;			// controler of ftp 

    NSPopUpButton connectionMenu;	//pop up menu to display connection names
    NSBrowser myFileBrowser;		//main file browser
    NSTextField ftpMessageText;		//display ftp status in file drawer
    
    NSWindow mainWindow;
    MyDataSource browserSource;
    NSTableView fileList;
    NSDrawer fileDrawer;
    NSButton deleteButton;
  
    NSButton sendButton;
    NSButton openButton;
    NSPanel dialog;
    NSTimer updateButtonTimer;
    NSSelector 	sendSelector,stopSelector;    
    NSProgressIndicator progressBar;
    
    Vector siteInfo;			// vector which holds site info data.
    Vector transferFileNames;		// vector which holds file data to be transfered
    TableDataSource tbs;		// Data source for table
    
    boolean transferStatus;
    
    int transferMode;			// Auto:0, ASCII: 1, BIN 2
    int transferActionMode = SEMI_AUTO; // Auto:0, Semi-Auto:1
    int menuItemIndex;  		// index of default selected item no of connection Menu
    int sortMode;			// whether or not to sort column
    int rememberMode;			// whheter or not to remember path
    
    static final int AUTO = 0;
    static final int ASCII = 1;
    static final int BIN = 2;
    static final int SEMI_AUTO = 1;
    static final int OFF = 0;
    static final int ON = 1;
    
    /////////////////////////////////////////
    ////// initialization
    ////////////////////////////////////////
    
    public void awakeFromNib(){
        //progressBar.setUsesThreadedAnimation(true);
        progressBar.removeFromSuperview();
        //progressBar.setNeedsDisplay(false);
        //progressBar.setControlTint(NSProgressIndicator.ClearControlTint);
       
        transferFileNames = new Vector();
       
        siteInfo = new Vector();
        (new FileAccessor()).readSetting(siteInfo);
        updateConnectionMenu();    
        if(connectionMenu.numberOfItems() > menuItemIndex){
            connectionMenu.selectItemAtIndex(menuItemIndex);
        }
        
	readDefaults();        
        setBrowserRoot();
                      
        myFileBrowser.setMaxVisibleColumns(5);
        myFileBrowser.setMinColumnWidth(120);
        myFileBrowser.setDoubleAction(new NSSelector("selectedByDouble",
            new Class[]{Object.class}));
            
        //gmcnt.setBoss(this);               
        //gmcnt.setTransferModeButton(transferMode);
        //gmcnt.setTransferActionButton(transferActionMode);
        
        //gmcnt.setRememberModeButton(rememberMode);

        //gmcnt.setSortModeButton(sortMode);
        //browserSource.setSortMode(sortMode);  
        
        gscnt.setSiteInfo(siteInfo);        
        
        //fileList.setEditable(false);
        tbs = new TableDataSource();
        tbs.setFileList(transferFileNames);
        fileList.setDataSource(tbs);
     
 

        gdcnt.initialize(this);
               
        transferStatus = false;
        sendSelector = new NSSelector("sendAction", new Class[] {getClass()} );
        stopSelector = new NSSelector("stopAction", new Class[] {getClass()} );            
        // create a timer which we'll use to update our "play" button text */
        updateButtonTimer = new NSTimer(
                                            2.0,
                                            this,
                                            new NSSelector("timerFired", new Class[] {getClass()} ),
                                            null,
                                            true);

        // register our NSTimer for the default run loop 
        NSRunLoop.currentRunLoop().addTimerForMode(updateButtonTimer, NSRunLoop.DefaultRunLoopMode); 
        //progressBar.setBackgroundColor(NSColor.clearColor());       
    }

    public void timerFired(Object sender)
    {
        if((transferFileNames.size() == 0)&&(fileDrawer.state() == NSDrawer.OpenState)){
            fileDrawer.close();
        }     
        
        if(transferStatus){
            String str = NSBundle.mainBundle().localizedStringForKey("CancelButtonMessage","Stop",null);
            sendButton.setTitle(str);
            sendButton.setAction(stopSelector);
        }
        else{
            String str = NSBundle.mainBundle().localizedStringForKey("SendButtonMessage","Send",null);
            sendButton.setTitle(str);
            sendButton.setAction(sendSelector);
        }
    }

    private void readDefaults(){
        NSUserDefaults defaults = NSUserDefaults.standardUserDefaults();
        menuItemIndex = defaults.integerForKey("connectionMenu");
        transferMode = defaults.integerForKey("transferMode");
        transferActionMode = defaults.integerForKey("transferActionMode");  
        sortMode = defaults.integerForKey("sortMode");   
        rememberMode = defaults.integerForKey("rememberMode"); 
        for(int i = 0;i<siteInfo.size();i++){
            ConnectionInfo info = (ConnectionInfo)(siteInfo.elementAt(i));
            info.setConnectedDate((NSDate)defaults.objectForKey("ConnectedDate"+info.getSetName()));
        }       
    }
    public void updateConnectionMenu(){
        connectionMenu.removeAllItems();
        for(int i = 0;i<siteInfo.size();i++){
            ConnectionInfo info = (ConnectionInfo)(siteInfo.elementAt(i));
            connectionMenu.addItem(info.getSetName());
        }
        setBrowserRoot();
    }

    
    ////////////////////////////////////////////////
    ////////// action from connection menu
    ////////////////////////////////////////////////
    
    public void connectionMenuChanged(Object sender) {
        NSUserDefaults defaults = NSUserDefaults.standardUserDefaults();      
        defaults.setIntegerForKey(connectionMenu.indexOfSelectedItem(),"connectionMenu");   
        setBrowserRoot();
        transferFileNames.removeAllElements();
        fileList.reloadData();
    }
    public ConnectionInfo getSelectedConnectionInfo(){
        return (ConnectionInfo)(siteInfo.elementAt(connectionMenu.indexOfSelectedItem()));
    }
    private void setBrowserRoot(){
        int index = connectionMenu.indexOfSelectedItem();
        if(index < 0) index = 0;
        ConnectionInfo info = null;
        if(siteInfo.size() == 0) return;
        
        info = (ConnectionInfo)(siteInfo.elementAt(index));
        browserSource.setRoot(info.getLocalDir());
        myFileBrowser.loadColumnZero();
        //myFileBrowser.displayAllColumns();
		myFileBrowser.setNeedsDisplay(true);
        String defaultPath = info.getDefaultPath();
        
        if(defaultPath == null) return;
        if(defaultPath.length() == 0) return;
	if(rememberMode == ON) myFileBrowser.setPath(defaultPath);
    }
    

    //////////////////////////////////////////////////////////
    /////// Action from Data Drawer
    /////////////////////////////////////////////////////////
    
    public void sendAction(Object sender) {    

        if(transferFileNames.size() == 0) return;
//System.out.println("tstatus = "+transferStatus);        
        if(transferStatus) return;
        transferStatus = true;
        
        if(gfcnt != null){
            if(gfcnt.isAlive()){
                try{
                    gfcnt.join(100);
                }
                catch(InterruptedException e){}
                return;
            }
            else{
                gfcnt = null;
            }
        }
        gfcnt = new GFTPControl();
        gfcnt.setBoss(this);
        ConnectionInfo info = getSelectedConnectionInfo();
        gfcnt.setInfo(info,transferMode);
        info.setConnectedDate(new NSDate());
        NSUserDefaults defaults = NSUserDefaults.standardUserDefaults();      
        defaults.setObjectForKey(info.getConnectedDate(),"ConnectedDate"+info.getSetName());   
        int myPool = NSAutoreleasePool.push();    
 	gfcnt.start();
        NSAutoreleasePool.pop(myPool);
    }  
    public void stopAction(Object sender){
        if(gfcnt != null){
            if(gfcnt.isAlive()){
                gfcnt.setInterrupt(true);
            }
        }
    }
    
    public void  deleteSelectedFile(Object sender){
        //int index = fileList.selectedRow();
        NSEnumerator enumerator = fileList.selectedRowEnumerator();
        Vector delfiles = new Vector();
        while(enumerator.hasMoreElements()){
            int index = ((Integer)(enumerator.nextElement())).intValue();
            if(index == -1) return; // nothin was selected
            delfiles.addElement(transferFileNames.elementAt(index));      
        }
        for(int i = 0;i<delfiles.size();i++){
            transferFileNames.removeElement(delfiles.elementAt(i));
        }
        fileList.reloadData(); 
		fileList.deselectAll(null);
        setDeleteButtonStatus();          
    }
    
	public void deleteAll(Object sender){
		transferFileNames.clear();
        fileList.reloadData(); 
		fileList.deselectAll(null);
        setDeleteButtonStatus();   	
	}
    
    public void tableItemSelected(Object sender){
	setDeleteButtonStatus();
    }

    private void setDeleteButtonStatus(){
       if((fileList.selectedRow() == -1)||transferStatus){
            deleteButton.setEnabled(false);
        }
        else{
            deleteButton.setEnabled(true);            
        }
    }
     ///////////////////////////////////////////////
    ////Notify from other controls
    ///////////////////////////////////////////////  
    
    // notify form GSettingControl//////////////////////////
   
     public void setTransferMode(int mode){
        transferMode = mode;
        NSUserDefaults defaults = NSUserDefaults.standardUserDefaults();                
        defaults.setIntegerForKey(transferMode,"transferMode");          
    }
    public void setTransferActionMode(int mode){
        transferActionMode = mode;  
        NSUserDefaults defaults = NSUserDefaults.standardUserDefaults();        
        defaults.setIntegerForKey(transferActionMode,"transferActionMode");       
    }    
    
/*    public void sortModeChanged(int mode){
	sortMode = mode;
        browserSource.setSortMode(sortMode);
        myFileBrowser.loadColumnZero();       
    }
 
    public void passRememberModeChanged(int mode){
        rememberMode = mode;               
    }*/             
   // notify from GFTPControl///////////////////////////
   
    public void setFtpMessage(String str){
        if(ftpMessageText == null) return;
        ftpMessageText.setStringValue(str);
    
    }
    public void ftpFinished(){
        transferStatus = false;
        if((transferActionMode == AUTO)&&(transferFileNames.size()>0)){
            sendAction(null);
        }
        //fileDrawer.close();
    }

    public void fileTransferStarted(String path){
        int index = findFileInfoIndexInList(path);
        fileList.selectRow(index,false);
    }
    
    public synchronized void fileTansferFinished(String path){
        int index = findFileInfoIndexInList(path);
	if(index == -1) return;
        transferFileNames.removeElementAt(index);
        fileList.reloadData(); 
        setDeleteButtonStatus();          
    }
    public synchronized Vector getFileToTransfer(){
        //if(transferActionMode == SEMI_AUTO) return;
        Vector fvect = new Vector();
        for(int i = 0;i<transferFileNames.size();i++){
            MyItem item = (MyItem)(transferFileNames.elementAt(i));
            fvect.addElement(new MyItem(item.path()));
        } 
        return fvect;
    }
    ///////////////////////////////////////////////
    //// Delegate from Browser 
    ///////////////////////////////////////////////    
        
    public void select(Object sender){
        int index = connectionMenu.indexOfSelectedItem();
        if(index < 0) return;
        if(rememberMode == ON){
            ConnectionInfo info = (ConnectionInfo)(siteInfo.elementAt(index));
            info.setDefaultPath(((NSBrowser)(sender)).path());
        }
        
        MyItem selectedItem = new MyItem((browserSource.getRoot())+myFileBrowser.path());
        if(selectedItem.isDirectory()){                
            openButton.setEnabled(false);
        }
        else{
            openButton.setEnabled(true);
        }
    }    
    
    public void selectedByDouble(Object sender){
        MyItem selectedItem = new MyItem((browserSource.getRoot())+((NSBrowser)(sender)).path());
        //System.out.println(selectedFile);  
        if(selectedItem.isDirectory()){
			Vector items = selectedItem.getAllChildren();
			for(int i=0;i<items.size();i++){
				addFileToList((MyItem)(items.get(i)));
			}
		}
		else{
			addFileToList(selectedItem);
		}
    }
    
    public void addFileToList(MyItem selectedItem){
        if(findFileInfoInList(selectedItem.path()) != null) return;
        
        ConnectionInfo info = getSelectedConnectionInfo();
        selectedItem.setShortPath(info.getShortFileName(selectedItem.path()));
        transferFileNames.addElement(selectedItem);
        fileList.reloadData();  
        
        if((fileDrawer.state() == NSDrawer.ClosedState)&&(transferFileNames.size() > 0)){
			setFtpMessage("");
            fileDrawer.open();// just added 
            NSButtonCell buttonCell = (NSButtonCell)sendButton.cell();
            mainWindow.setDefaultButtonCell(buttonCell);            
        }


        if(transferActionMode == AUTO){
            sendAction(null);
        }
        deleteButton.setEnabled(false);
    }
    
    private MyItem findFileInfoInList(String spath){
        for (Enumeration e = transferFileNames.elements() ; e.hasMoreElements() ;) {
            MyItem citem = (MyItem)e.nextElement();
            if(spath.equals(citem.path())){
                return citem;
            }
        }
        return null;    
    }
    
    private int findFileInfoIndexInList(String path){
        for(int i = 0;i<transferFileNames.size();i++){
            MyItem citem = (MyItem)transferFileNames.elementAt(i);
            if(path.equals(citem.path())){
                return i;
            }
        }
        return -1;
    }
    
    ///////////////////////////////////////////////
    ////// Open Document
    //////////////////////////////////////////////
    public void openDocument(Object sender){
        MyItem selectedItem = new MyItem((browserSource.getRoot())+myFileBrowser.path());
        //System.out.println(selectedFile);  
        if(selectedItem.isDirectory()) return;
        (NSWorkspace.sharedWorkspace()).openFile( selectedItem.path(), null, true);        
    }
    ///////////////////////////////////////////////
    //// Delegate from File's owner
    ///////////////////////////////////////////////    
    public  void applicationDidFinishLaunching(NSNotification aNotification){
     
    }
    
    public void applicationWillTerminate(NSNotification aNotification){
        (NSUserDefaults.standardUserDefaults()).synchronize();
    }
	
	public void showHelp(Object sender){
        NSAlertPanel.beginAlertSheet( 
        "Message", "OK", "Cancel",null, mainWindow, this,
        new NSSelector("sheetDidEnd", new Class[]{NSWindow.class, int.class,Object.class}), 
             null,
             null, 
             NSBundle.localizedString("willOpenPage"));      
    }
    public void sheetDidEnd(NSWindow sheet, int returnCode, Object contextInfo){
        if(returnCode == NSAlertPanel.DefaultReturn){
			URL url = null;
			try{
				url = new URL("http://otsubo.info/contents/GBPut/gbdownload.html");
			}
			catch(Exception e){
				System.out.println(e);
			}        
			if(url != null){
				NSWorkspace.sharedWorkspace().openURL(url);
			}
        }
    }   
}
