//
//  ConnectionInfo.java
//  GFPut
//
//  Created by grgr56 on Sun Nov 25 2001.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//
import com.apple.cocoa.foundation.*;
import com.apple.cocoa.application.*;

public class ConnectionInfo {
    String setName;
    String hostAddress;
    String userName;
    String password;
    String remoteDir;
    String localDir;
    String defaultPath;
    NSDate connectedDate;
    
    public ConnectionInfo(){
        connectedDate = new NSDate();
    }
    
    public void setSetName(String str){
        setName = str;
    }
    public ConnectionInfo duplicate(){
        ConnectionInfo ret = new ConnectionInfo();
        ret.setSetName(setName);
        ret.setHostAddress(hostAddress);
        ret.setUserName(userName);
        ret.setPassword(password);
        ret.setRemoteDir(remoteDir);
        ret.setLocalDir(localDir);
        ret.setDefaultPath(defaultPath);
        ret.setConnectedDate(new NSDate(0,connectedDate));
        return ret;
    }
    public String getSetName(){ return setName;}
    
    public void setHostAddress(String st){
        hostAddress = st;
    }
    public String getHostAddress(){
        return hostAddress;
    }
    
    public void setUserName(String st){
        userName = st;
    }
    public String getUserName(){
        return userName;
    }
    
    public void setPassword(String st){
        password = st;
    }
    public String getPassword(){
        return password;
    }
    
    public void setRemoteDir(String st){
        remoteDir = st;
    }
    public String getRemoteDir(){
        return remoteDir;
    }
    
    public void setLocalDir(String st){
        localDir = st;
    }
    public String getLocalDir(){
        return localDir;
    }
    public void setDefaultPath(String path){
        defaultPath = path;
    }
    public String getDefaultPath(){
        return defaultPath;
    }

    public void setConnectedDate(NSDate date){
        connectedDate = new NSDate(0,date);
    }
    public NSDate getConnectedDate(){
        if(connectedDate == null) return new NSDate();
        else return connectedDate;
    }

    public String getRealRemoteDir(String filename){
        int startIndex = localDir.length();
        int endIndex = filename.lastIndexOf("/");
        if(startIndex > endIndex) return null;
        return (remoteDir +(filename.substring(startIndex,endIndex)));
    }
    
    public String getRealFileName(String filename){
        int index = filename.lastIndexOf("/");
        return filename.substring(index+1);
    }
	public String getRemoteFileName(String filename){
		return getRealRemoteDir(filename)+"/"+getRealFileName(filename);
	}
    public String getShortFileName(String filename){
        int index = localDir.length();
        if(index >= (filename.length())) return null;
        return filename.substring(index);
    }
    
    public boolean isValid(String filename){
        if(filename.indexOf(localDir) == -1) return false;
        else return true;
    }
}
