/*
 * Decompiled with CFR 0.152.
 */
package cz.dhl.util;

public class CoHandleMap {
    private Entry[] map = new Entry[5];
    int used = 0;

    private void resize() {
        Entry[] old = this.map;
        this.map = new Entry[old.length + 5];
        System.arraycopy(old, 0, this.map, 0, old.length);
    }

    private int getIndex(Object key) {
        for (int i = 0; i < this.used; ++i) {
            if (this.map[i].key != key) continue;
            return i;
        }
        return -1;
    }

    private void clearIndex(int i) {
        this.map[i].key = null;
        this.map[i].value = null;
        this.map[i] = null;
    }

    public void put(Object key, Object value) {
        int i = this.getIndex(key);
        if (i != -1) {
            this.map[i].key = key;
            this.map[i].value = value;
        } else {
            this.map[this.used] = new Entry(key, value);
            ++this.used;
            if (this.map.length == this.used) {
                this.resize();
            }
        }
    }

    public Object get(Object key) {
        int i = this.getIndex(key);
        if (i != -1) {
            return this.map[i].value;
        }
        return null;
    }

    public void remove(Object key) {
        int i = this.getIndex(key);
        if (i != -1) {
            this.clearIndex(i);
            for (int m = i; m < this.used - 1; ++m) {
                this.map[m] = this.map[m + 1];
            }
            --this.used;
        }
    }

    public void removeAll() {
        for (int i = 0; i < this.used; ++i) {
            this.clearIndex(i);
        }
        this.used = 0;
    }

    private class Entry {
        Object key;
        Object value;

        Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

