/*
 * Decompiled with CFR 0.152.
 */
package cz.dhl.swing;

import cz.dhl.ftp.Ftp;
import cz.dhl.ftp.FtpFile;
import cz.dhl.io.CoFile;
import cz.dhl.swing.JCoEventQueue;
import cz.dhl.swing.JFtpCommandPanel;
import cz.dhl.swing.JFtpConnectPanel;
import cz.dhl.swing.JFtpLoginPanel;
import java.io.IOException;
import javax.swing.SwingUtilities;

final class JFtpEventQueue
extends JCoEventQueue {
    Ftp client = null;
    JFtpCommandPanel command = null;
    JFtpConnectPanel connect = null;
    JFtpLoginPanel login = null;

    JFtpEventQueue() {
    }

    void update(CoFile dir) {
        if (dir == null || dir.isConnected()) {
            this.panel.showCard("Log");
            this.browse.setEnabled(false);
            new Thread(new JCoEventQueue.Update(dir)).start();
        } else {
            this.disconnect();
        }
    }

    void connect() {
        if (this.client != null && !this.client.isConnected()) {
            this.panel.showCard("Log");
            this.login.setEnabled(false);
            this.connect.setEnabled(false, false);
            new Thread(new Connect()).start();
        }
    }

    void disconnect() {
        this.panel.showCard("Log");
        this.connect.setEnabled(false, false);
        new Thread(new Disconnect()).start();
    }

    void command() {
        if (this.client.isConnected()) {
            String line = this.command.getText();
            new Thread(new Command(line)).start();
        }
    }

    class Command
    implements Runnable {
        String line;

        Command(String line) {
            this.line = line;
        }

        public void run() {
            JFtpEventQueue.this.client.command(this.line);
        }
    }

    class DisconnectUI
    implements Runnable {
        DisconnectUI() {
        }

        public void run() {
            JFtpEventQueue.this.login.setEnabled(true);
            JFtpEventQueue.this.connect.setEnabled(true, false);
            JFtpEventQueue.this.command.setEnabled(false);
            JFtpEventQueue.this.update(null);
        }
    }

    class Disconnect
    implements Runnable {
        Disconnect() {
        }

        public void run() {
            JFtpEventQueue.this.client.disconnect();
            SwingUtilities.invokeLater(new DisconnectUI());
        }
    }

    class ConnectUI
    implements Runnable {
        boolean done;
        FtpFile cwd;

        ConnectUI(boolean done, FtpFile cwd) {
            this.done = done;
            this.cwd = cwd;
        }

        public void run() {
            if (this.done) {
                JFtpEventQueue.this.connect.setEnabled(false, true);
                JFtpEventQueue.this.command.setEnabled(true);
                JFtpEventQueue.this.update(this.cwd);
            } else {
                JFtpEventQueue.this.login.setEnabled(true);
                JFtpEventQueue.this.connect.setEnabled(true, false);
            }
        }
    }

    class Connect
    implements Runnable {
        Connect() {
        }

        public void run() {
            FtpFile cwd = null;
            JFtpEventQueue.this.login.setConnect();
            boolean done = false;
            try {
                done = JFtpEventQueue.this.client.connect(JFtpEventQueue.this.login.connect);
                if (done) {
                    cwd = new FtpFile(JFtpEventQueue.this.client.pwd(), JFtpEventQueue.this.client);
                }
            }
            catch (IOException e) {
                JFtpEventQueue.this.client.getContext().printerr(e);
            }
            SwingUtilities.invokeLater(new ConnectUI(done, cwd));
        }
    }
}

