/*
 * Decompiled with CFR 0.152.
 */
package cz.dhl.swing;

import cz.dhl.io.CoFile;
import cz.dhl.swing.JCoBrowsePanel;
import cz.dhl.ui.CoProgress;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

class JCoProgressDialog
extends JDialog
implements CoProgress {
    static final int PROGRESS_COPY = 1;
    static final int PROGRESS_DELETE = 2;
    static final int PROGRESS_RENAME = 3;
    static final int PROGRESS_MAKEDIR = 4;
    JLabel filelabel = null;
    JLabel tolabel = null;
    JLabel progress = null;
    JButton cancel = new JButton("Cancel");
    CoFile file = null;
    CoFile to = null;
    boolean abort = false;
    long done = 0L;
    long total;
    long delay;
    Runnable remove = new Runnable(){

        public void run() {
            JCoProgressDialog.this.filelabel.setText("File: " + ((Object)JCoProgressDialog.this.file).toString());
            if (JCoProgressDialog.this.progress != null) {
                JCoProgressDialog.this.progress.setText("");
            }
            JCoProgressDialog.this.pack();
        }
    };
    Runnable copy = new Runnable(){

        public void run() {
            JCoProgressDialog.this.tolabel.setText("To: " + ((Object)JCoProgressDialog.this.to).toString());
            JCoProgressDialog.this.filelabel.setText("File: " + ((Object)JCoProgressDialog.this.file).toString());
            if (JCoProgressDialog.this.progress != null) {
                if (!JCoProgressDialog.this.file.isDirectory()) {
                    JCoProgressDialog.this.progress.setText("" + JCoProgressDialog.this.done + " of " + JCoProgressDialog.this.total);
                } else {
                    JCoProgressDialog.this.progress.setText("");
                }
            }
            JCoProgressDialog.this.pack();
        }
    };
    Timer fresher = null;
    ActionListener refreshEvent = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (JCoProgressDialog.this.progress != null) {
                JCoProgressDialog.this.progress.setText("" + JCoProgressDialog.this.done + " of " + JCoProgressDialog.this.total + (JCoProgressDialog.this.delay > 0L ? " " + JCoProgressDialog.this.delay + "sec no answer" : ""));
            }
        }
    };

    static JCoProgressDialog newProgressDialog(JCoBrowsePanel browse, int operation) {
        Container object;
        for (object = browse.getParent(); object != null && !(object instanceof Frame); object = object.getParent()) {
        }
        if (object != null) {
            JCoProgressDialog dialog = new JCoProgressDialog((Frame)object, operation);
            dialog.pack();
            ((Component)dialog).setVisible(true);
            return dialog;
        }
        return null;
    }

    JCoProgressDialog(Frame parent, int operation) {
        super(parent);
        int gridy = 1;
        switch (operation) {
            case 1: {
                this.setTitle("Copying ...");
                gridy = 3;
                break;
            }
            case 2: {
                this.setTitle("Deleting ...");
                gridy = 1;
                break;
            }
            case 3: {
                this.setTitle("Renaming ...");
                gridy = 2;
                break;
            }
            case 4: {
                this.setTitle("Creating Dir ...");
                gridy = 1;
            }
        }
        JPanel statuspanel = new JPanel(new GridLayout(gridy, 1));
        JPanel commandpanel = new JPanel(new FlowLayout(1));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)statuspanel, "Center");
        this.filelabel = new JLabel("File: ");
        statuspanel.add(this.filelabel);
        if (operation != 2 && operation != 4) {
            this.tolabel = new JLabel("To: ");
            statuspanel.add(this.tolabel);
        }
        if (operation == 1) {
            this.progress = new JLabel("");
            statuspanel.add(this.progress);
        }
        this.getContentPane().add((Component)commandpanel, "South");
        commandpanel.add(this.cancel);
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JCoProgressDialog.this.abort();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JCoProgressDialog.this.abort();
            }
        });
        Point p = parent.getLocationOnScreen();
        p.translate(0, 0);
        ((Component)this).setLocation(p);
        this.setResizable(false);
    }

    void close() {
        this.abort();
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void setFile(CoFile newfile) {
        this.file = newfile;
        this.setRefreshRate(0);
        SwingUtilities.invokeLater(this.remove);
    }

    public void setFile(CoFile newto, CoFile newfile) {
        this.to = newto;
        this.file = newfile;
        this.done = 0L;
        this.total = this.file.length();
        this.delay = 0L;
        this.setRefreshRate(300);
        SwingUtilities.invokeLater(this.copy);
    }

    public void setRefreshRate(int rate) {
        if (rate != 0) {
            if (this.fresher == null) {
                this.fresher = new Timer(rate, this.refreshEvent);
                this.fresher.start();
            }
            this.fresher.setDelay(rate);
        } else if (this.fresher != null) {
            this.fresher.stop();
            this.fresher.removeActionListener(this.refreshEvent);
            this.fresher = null;
        }
    }

    public void setProgress(int increment) {
        this.done += (long)increment;
        if (increment > 0) {
            this.delay = 0L;
        }
    }

    public void setDelay(long increment) {
        this.delay += (long)((int)(increment / 1000L));
    }

    public boolean isAborted() {
        return this.abort;
    }

    public void abort() {
        this.setRefreshRate(0);
        this.abort = true;
    }
}

