/*
 * Decompiled with CFR 0.152.
 */
package cz.dhl.swing;

import cz.dhl.io.CoFile;
import cz.dhl.io.CoSort;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class JCoFileTable
extends JTable {
    private Icon directoryIcon = null;
    private Icon fileIcon = null;
    private CoFile[] files = new CoFile[0];
    private CoFile[] origfiles = new CoFile[0];
    private int orderI = 1;
    private String[] filterS = new String[0];
    private final DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){

        public void setValue(Object value) {
            if (value instanceof CoFile) {
                JCoFileTable.this.installIcons();
                CoFile f = (CoFile)value;
                Icon icon = f.isDirectory() ? JCoFileTable.this.directoryIcon : JCoFileTable.this.fileIcon;
                if (icon != null) {
                    this.setIcon(icon);
                }
                this.setText(f.getName());
            } else {
                super.setValue(value);
            }
        }
    };
    private final AbstractTableModel model = new AbstractTableModel(){
        String[] names = new String[]{"File Name", "Property", "Last Modified"};

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return JCoFileTable.this.files.length;
        }

        public Object getValueAt(int row, int col) {
            Object item;
            switch (col) {
                case 0: {
                    item = JCoFileTable.this.files[row];
                    break;
                }
                case 1: {
                    item = JCoFileTable.this.files[row].propertyString();
                    break;
                }
                case 2: {
                    item = JCoFileTable.this.files[row].lastModifiedString();
                    break;
                }
                default: {
                    item = "";
                }
            }
            return item;
        }

        public String getColumnName(int column) {
            return this.names[column];
        }
    };

    private void installIcons() {
        if (this.directoryIcon == null) {
            this.directoryIcon = UIManager.getIcon("FileView.directoryIcon");
        }
        if (this.fileIcon == null) {
            this.fileIcon = UIManager.getIcon("FileView.fileIcon");
        }
    }

    public JCoFileTable() {
        this.setModel(this.model);
        TableColumn column = this.getColumn("File Name");
        column.setCellRenderer(this.renderer);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setShowGrid(false);
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                char ch = e.getKeyChar();
                int[] is = JCoFileTable.this.getSelectedRows();
                if (e.getModifiers() != 1) {
                    int i;
                    int n = i = is.length > 0 ? is[is.length - 1] + 1 : 0;
                    while (i < JCoFileTable.this.files.length) {
                        if (JCoFileTable.this.files[i].startsWithIgnoreCase(ch)) {
                            JCoFileTable.this.setSelectedFile(JCoFileTable.this.files[i]);
                            return;
                        }
                        ++i;
                    }
                    for (i = 0; i < JCoFileTable.this.files.length; ++i) {
                        if (!JCoFileTable.this.files[i].startsWithIgnoreCase(ch)) continue;
                        JCoFileTable.this.setSelectedFile(JCoFileTable.this.files[i]);
                        return;
                    }
                } else {
                    int i;
                    int n = i = is.length > 0 ? is[is.length - 1] - 1 : 0;
                    while (i >= 0) {
                        if (JCoFileTable.this.files[i].startsWithIgnoreCase(ch)) {
                            JCoFileTable.this.setSelectedFile(JCoFileTable.this.files[i]);
                            return;
                        }
                        --i;
                    }
                    for (i = JCoFileTable.this.files.length - 1; i >= 0; --i) {
                        if (!JCoFileTable.this.files[i].startsWithIgnoreCase(ch)) continue;
                        JCoFileTable.this.setSelectedFile(JCoFileTable.this.files[i]);
                        return;
                    }
                }
            }
        });
        try {
            this.getClass().getMethod("getActionMap", new Class[0]);
            class NullAction
            implements Action {
                Action delegate;
                boolean setOnce = false;

                public NullAction(JTable table, Action delegate) {
                    this.delegate = delegate;
                }

                public void addPropertyChangeListener(PropertyChangeListener listener) {
                    this.delegate.addPropertyChangeListener(listener);
                }

                public void removePropertyChangeListener(PropertyChangeListener listener) {
                    this.delegate.removePropertyChangeListener(listener);
                }

                public Object getValue(String key) {
                    return this.delegate.getValue(key);
                }

                public void putValue(String key, Object value) {
                    this.delegate.putValue(key, value);
                }

                public void setEnabled(boolean enabled) {
                    this.delegate.setEnabled(enabled);
                }

                public boolean isEnabled() {
                    return this.delegate.isEnabled();
                }

                public void actionPerformed(ActionEvent event) {
                }
            }
            this.getActionMap().put("selectNextColumnCell", new NullAction(this, this.getActionMap().get("selectNextColumnCell")));
            this.getActionMap().put("selectPreviousColumnCell", new NullAction(this, this.getActionMap().get("selectPreviousColumnCell")));
            this.getActionMap().put("selectNextRowCell", new NullAction(this, this.getActionMap().get("selectNextRowCell")));
            this.getActionMap().put("selectPreviousRowCell", new NullAction(this, this.getActionMap().get("selectPreviousRowCell")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CoFile[] getFiles() {
        return this.origfiles;
    }

    public void setFiles(CoFile[] files) {
        this.origfiles = files == null ? new CoFile[0] : files;
        this.files = CoSort.listSplit(CoSort.listOrder(CoSort.listFilter(this.origfiles, this.filterS), this.orderI));
        this.setEnabled(this.files.length > 0);
        this.model.fireTableDataChanged();
    }

    public CoFile getSelectedFile() {
        int[] is = this.getSelectedRows();
        if (is != null && is.length == 1 && is[0] >= 0 && is[0] < this.files.length) {
            return this.files[is[0]];
        }
        return null;
    }

    public void setSelectedFile(CoFile file) {
        this.clearSelection();
        for (int j = 0; j < this.files.length; ++j) {
            if (!this.files[j].equals(file)) continue;
            this.addRowSelectionInterval(j, j);
            break;
        }
    }

    public CoFile[] getSelectedFiles() {
        int[] is = this.getSelectedRows();
        CoFile[] fs = new CoFile[is.length];
        for (int i = 0; i < is.length; ++i) {
            fs[i] = this.files[is[i]];
        }
        return fs;
    }

    public void setSelectedFiles(CoFile[] files) {
        this.clearSelection();
        block0: for (int i = 0; i < files.length; ++i) {
            for (int j = 0; j < this.files.length; ++j) {
                if (!this.files[j].equals(files[i])) continue;
                this.addRowSelectionInterval(j, j);
                continue block0;
            }
        }
    }

    public void deselectAllFiles() {
        this.clearSelection();
    }

    public void setOrder(int order) {
        this.orderI = order;
        this.setFiles(this.origfiles);
    }

    public void setFilter(String[] filter) {
        this.filterS = filter;
        this.setFiles(this.origfiles);
    }
}

