/*
 * Decompiled with CFR 0.152.
 */
package cz.dhl.swing;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class JCoFileActions {
    protected Action deleteAction = new DeleteAction();
    protected Action renameAction = new RenameAction();
    protected Action newDirAction = new NewDirAction();
    protected Action refreshAction = new RefreshAction();
    private static final String SORT_SEQ_ID = "SORT_SEQ_ID";
    protected Action sortByAction = new SortByAction();

    protected void delete() {
    }

    protected void rename() {
    }

    protected void newDir() {
    }

    protected void refresh() {
    }

    protected void sortBy(int sort) {
    }

    private JMenuItem createMenuItem(String name, String description, Action action, int value) {
        JMenuItem menuItem = new JMenuItem(name);
        menuItem.setAction(action);
        menuItem.setToolTipText(description);
        menuItem.putClientProperty(SORT_SEQ_ID, new Integer(value));
        return menuItem;
    }

    JPopupMenu createFilePopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.deleteAction);
        menu.add(this.renameAction);
        menu.add(this.newDirAction);
        menu.add(new JSeparator());
        JMenu sortBy = new JMenu("Sort by");
        menu.add(sortBy);
        sortBy.add(this.createMenuItem("Name", "Sort by Name", this.sortByAction, 1));
        sortBy.add(this.createMenuItem("Type", "Sort by Type", this.sortByAction, 2));
        sortBy.add(this.createMenuItem("Date", "Sort by Date", this.sortByAction, 4));
        sortBy.add(this.createMenuItem("Size", "Sort by Size", this.sortByAction, 3));
        sortBy.add(this.createMenuItem("None", "Sort by None", this.sortByAction, 6));
        JMenuItem filterBy = new JMenuItem("Filter ...");
        menu.add(filterBy);
        menu.add(new JSeparator());
        menu.add(this.refreshAction);
        return menu;
    }

    JMenu createFileMenu() {
        JMenu menu = new JMenu();
        JMenuItem delete = new JMenuItem("Delete");
        menu.add(this.deleteAction);
        menu.add(this.renameAction);
        menu.add(this.newDirAction);
        menu.add(new JSeparator());
        JMenu sortBy = new JMenu("Sort by");
        menu.add(sortBy);
        sortBy.add(this.createMenuItem("Name", "Sort by Name", this.sortByAction, 1));
        sortBy.add(this.createMenuItem("Type", "Sort by Type", this.sortByAction, 2));
        sortBy.add(this.createMenuItem("Date", "Sort by Date", this.sortByAction, 4));
        sortBy.add(this.createMenuItem("Size", "Sort by Size", this.sortByAction, 3));
        sortBy.add(this.createMenuItem("None", "Sort by None", this.sortByAction, 6));
        JMenuItem filterBy = new JMenuItem("Filter ...");
        menu.add(filterBy);
        menu.add(new JSeparator());
        menu.add(this.refreshAction);
        return menu;
    }

    final class SortByAction
    extends AbstractAction {
        SortByAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JMenuItem) {
                Integer sort = (Integer)((JMenuItem)actionEvent.getSource()).getClientProperty(JCoFileActions.SORT_SEQ_ID);
                JCoFileActions.this.sortBy(sort != null ? sort : 6);
            }
        }
    }

    final class RefreshAction
    extends AbstractAction {
        RefreshAction() {
            this.putValue("Name", "Refresh");
            this.putValue("ShortDescription", "Refresh");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCoFileActions.this.newDir();
        }
    }

    final class NewDirAction
    extends AbstractAction {
        NewDirAction() {
            this.putValue("Name", "New Dir");
            this.putValue("ShortDescription", "Create new directory ...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCoFileActions.this.newDir();
        }
    }

    final class RenameAction
    extends AbstractAction {
        RenameAction() {
            this.putValue("Name", "Rename ...");
            this.putValue("ShortDescription", "Rename selected file ...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCoFileActions.this.rename();
        }
    }

    final class DeleteAction
    extends AbstractAction {
        DeleteAction() {
            this.putValue("Name", "Delete");
            this.putValue("ShortDescription", "Delete selected file");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCoFileActions.this.delete();
        }
    }
}

