/*
 * Decompiled with CFR 0.152.
 */
package cz.dhl.swing;

import cz.dhl.ftp.Ftp;
import cz.dhl.io.CoFile;
import cz.dhl.io.CoLoad;
import cz.dhl.io.CoSource;
import cz.dhl.io.LocalSource;
import cz.dhl.swing.JCoBrowsePanel;
import cz.dhl.swing.JCoControlPanel;
import cz.dhl.swing.JCoEnterDialog;
import cz.dhl.swing.JCoProgressDialog;
import cz.dhl.swing.JFtpEventQueue;
import cz.dhl.swing.JLocalEventQueue;
import cz.dhl.ui.CoProgress;
import cz.dhl.ui.CoStatus;
import cz.dhl.ui.CoTabbed;
import cz.dhl.util.CoHandleMap;
import javax.swing.SwingUtilities;

abstract class JCoEventQueue {
    boolean active = false;
    CoFile[] selfiles = new CoFile[0];
    JCoEventQueue oposite = null;
    JCoControlPanel control = null;
    JCoBrowsePanel browse = null;
    CoTabbed panel = new CoTabbed(){

        public void showCard(String name) {
        }
    };
    CoStatus status = new CoStatus(){

        public void setSize(String s) {
        }

        public void setDate(String s) {
        }
    };
    protected static CoHandleMap threads = new CoHandleMap();

    JCoEventQueue() {
    }

    void update(CoFile dir) {
        this.panel.showCard("Log");
        this.browse.setEnabled(false);
        new Thread(new Update(dir)).start();
    }

    void copyFiles() {
        if (this.active && this.oposite != null) {
            CoFile[] files = this.browse.getSelectedFiles();
            CoFile to = this.oposite.browse.getDir();
            if (files != null && to != null && (files.length > 0 || to != null)) {
                if (this.oposite instanceof JFtpEventQueue) {
                    this.oposite.copyFiles(to, files);
                } else {
                    this.copyFiles(to, files);
                }
            }
        }
    }

    void copyFiles(CoFile to, CoFile[] files) {
        this.panel.showCard("Log");
        JCoProgressDialog progress = JCoProgressDialog.newProgressDialog(this.browse, 1);
        if (progress != null) {
            new Thread(new CopyFiles(progress, to, files)).start();
        }
    }

    void deleteFiles() {
        CoFile[] files;
        if (this.active && (files = this.browse.getSelectedFiles()) != null && files.length > 0) {
            this.deleteFiles(files);
        }
    }

    void deleteFiles(CoFile[] files) {
        this.panel.showCard("Log");
        JCoProgressDialog progress = JCoProgressDialog.newProgressDialog(this.browse, 2);
        if (progress != null) {
            new Thread(new DeleteFiles(progress, files)).start();
        }
    }

    void renameFile() {
        CoFile file;
        if (this.active && (file = this.browse.getSelectedFile()) != null) {
            JCoEnterDialog.newEnterDialog(this.browse, this, file, 3);
        }
    }

    void renameFile(String to, CoFile file) {
        this.panel.showCard("Log");
        JCoProgressDialog progress = JCoProgressDialog.newProgressDialog(this.browse, 3);
        if (progress != null) {
            progress.setFile(file.newFileRename(to), file);
            new Thread(new RenameFile(progress, file.newFileRename(to), file)).start();
        }
    }

    void makeDir() {
        CoFile cur;
        if (this.active && (cur = this.browse.getDir()) != null) {
            JCoEnterDialog.newEnterDialog(this.browse, this, cur, 4);
        }
    }

    void makeDir(String dir, CoFile cur) {
        this.panel.showCard("Log");
        JCoProgressDialog progress = JCoProgressDialog.newProgressDialog(this.browse, 4);
        if (progress != null) {
            progress.setFile(cur.newFileChild(dir));
            new Thread(new MakeDir(progress, dir, cur)).start();
        }
    }

    void dirEvent() {
        this.update(this.browse.getSelectedDir());
    }

    void focusEvent() {
        if (this.oposite != null && this.oposite.active) {
            this.oposite.active = false;
            this.oposite.selfiles = this.oposite.browse.getSelectedFiles();
            this.oposite.browse.deselectAllFiles();
            this.oposite.browse.setActiveBorder(false);
        }
        if (!this.active) {
            this.active = true;
            this.browse.setSelectedFiles(this.selfiles);
            this.browse.setActiveBorder(true);
        }
    }

    void statusEvent() {
        CoFile f = this.browse.getSelectedFile();
        if (f != null) {
            this.status.setSize(f.propertyString());
            this.status.setDate(f.lastModifiedString());
        } else {
            CoFile[] fs = this.browse.getSelectedFiles();
            if (fs != null) {
                long sum = 0L;
                for (int i = 0; i < fs.length; ++i) {
                    sum += fs[i].length();
                }
                this.status.setSize("" + sum);
                this.status.setDate(fs.length + " files");
            }
        }
    }

    void fileEvent() {
        CoFile f = this.browse.getSelectedFile();
        if (f != null) {
            this.update(f);
        }
    }

    static JCoEventQueue getEventQueue(CoSource source) {
        JCoEventQueue thread = (JCoEventQueue)threads.get(source);
        if (thread == null) {
            if (source instanceof LocalSource) {
                thread = new JLocalEventQueue();
                threads.put(source, thread);
            } else if (source instanceof Ftp) {
                thread = new JFtpEventQueue();
                threads.put(source, thread);
            }
        }
        return thread;
    }

    class MakeDir
    implements Runnable {
        JCoProgressDialog progress;
        String dir;
        CoFile cur;

        MakeDir(JCoProgressDialog progress, String dir, CoFile cur) {
            this.progress = progress;
            this.dir = dir;
            this.cur = cur;
        }

        public void run() {
            this.cur.newFileChild(this.dir).mkdir();
            SwingUtilities.invokeLater(new DeleteFilesUI(this.progress));
        }
    }

    class RenameFile
    implements Runnable {
        JCoProgressDialog progress;
        CoFile to;
        CoFile file;

        RenameFile(JCoProgressDialog progress, CoFile to, CoFile file) {
            this.progress = progress;
            this.to = to;
            this.file = file;
        }

        public void run() {
            this.file.renameTo(this.to);
            SwingUtilities.invokeLater(new DeleteFilesUI(this.progress));
        }
    }

    class DeleteFilesUI
    implements Runnable {
        JCoProgressDialog progress;

        DeleteFilesUI(JCoProgressDialog progress) {
            this.progress = progress;
        }

        public void run() {
            this.progress.close();
            JCoEventQueue.this.update(JCoEventQueue.this.browse.getDir());
        }
    }

    class DeleteFiles
    implements Runnable {
        JCoProgressDialog progress;
        CoFile[] files;

        DeleteFiles(JCoProgressDialog progress, CoFile[] files) {
            this.progress = progress;
            this.files = files;
        }

        public void run() {
            CoLoad.delete(this.files, this.progress);
            SwingUtilities.invokeLater(new DeleteFilesUI(this.progress));
        }
    }

    class CopyFilesUI
    implements Runnable {
        JCoProgressDialog progress;

        CopyFilesUI(JCoProgressDialog progress) {
            this.progress = progress;
        }

        public void run() {
            this.progress.close();
            JCoEventQueue.this.update(JCoEventQueue.this.browse.getDir());
            JCoEventQueue.this.oposite.update(JCoEventQueue.this.oposite.browse.getDir());
        }
    }

    class CopyFiles
    implements Runnable {
        JCoProgressDialog progress;
        CoFile to;
        CoFile[] files;

        CopyFiles(JCoProgressDialog progress, CoFile to, CoFile[] files) {
            this.progress = progress;
            this.to = to;
            this.files = files;
        }

        public void run() {
            CoLoad.copy(this.to, this.files, (CoProgress)this.progress);
            SwingUtilities.invokeLater(new CopyFilesUI(this.progress));
        }
    }

    class UpdateUI
    implements Runnable {
        CoFile dir;
        CoFile[] files;

        UpdateUI(CoFile dir, CoFile[] files) {
            this.dir = dir;
            this.files = files;
        }

        public void run() {
            CoFile[] sel = JCoEventQueue.this.browse.getSelectedFiles();
            JCoEventQueue.this.browse.setDir(this.dir);
            JCoEventQueue.this.browse.setFiles(this.files);
            JCoEventQueue.this.browse.setSelectedFiles(sel);
            JCoEventQueue.this.panel.showCard(this.dir != null ? "List" : "Login");
        }
    }

    class Update
    implements Runnable {
        CoFile dir;
        CoFile[] files = null;

        Update(CoFile dir) {
            this.dir = dir;
        }

        public void run() {
            if (this.dir != null) {
                this.files = this.dir.listCoFiles();
                if (this.files == null) {
                    this.dir = JCoEventQueue.this.browse.getDir();
                    this.files = JCoEventQueue.this.browse.getFiles();
                }
            }
            SwingUtilities.invokeLater(new UpdateUI(this.dir, this.files));
        }
    }
}

