/*
 * Decompiled with CFR 0.152.
 */
package cz.dhl.swing;

import cz.dhl.io.CoFile;
import cz.dhl.io.CoSort;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.UIManager;

public class JCoDirComboBox
extends JComboBox {
    private Icon hardDriveIcon = null;
    private Icon directoryIcon = null;
    private Vector roots = null;
    private CoFile[] dirs = new CoFile[0];
    private CoFile dir = null;
    CoFile sel = null;
    private ActionListener listener = null;
    private static final int space = 10;

    private void installIcons() {
        if (this.hardDriveIcon == null) {
            this.hardDriveIcon = UIManager.getIcon("FileView.hardDriveIcon");
        }
        if (this.directoryIcon == null) {
            this.directoryIcon = UIManager.getIcon("FileView.directoryIcon");
        }
    }

    public JCoDirComboBox() {
        this.setModel(new DirModel());
        this.setRenderer(new DirRenderer());
    }

    public void setDirActionListener(ActionListener listener) {
        this.listener = listener;
    }

    public CoFile getDir() {
        return this.dir;
    }

    public void setDir(CoFile dir) {
        this.dir = dir;
        this.sel = dir;
        if (dir != null) {
            if (this.roots == null) {
                this.roots = new Vector();
                CoFile[] newroots = dir.listCoRoots();
                for (int i = 0; i < newroots.length; ++i) {
                    this.roots.addElement(newroots[i]);
                }
            }
            Vector newdirs = (Vector)this.roots.clone();
            int n = dir.getPathDepth();
            for (int i = 1; i < n; ++i) {
                newdirs.addElement(dir.getPathFragment(i));
            }
            if (n >= 1) {
                newdirs.addElement(dir);
            }
            this.dirs = new CoFile[newdirs.size()];
            newdirs.copyInto(this.dirs);
            this.dirs = CoSort.listOrder(this.dirs, 5);
        } else {
            this.dirs = new CoFile[0];
        }
        ((DirModel)this.getModel()).update();
        this.setEnabled(this.dirs.length > 0);
    }

    public CoFile getSelectedDir() {
        return this.sel;
    }

    private class DirModel
    extends AbstractListModel
    implements ComboBoxModel {
        private DirModel() {
        }

        public void update() {
            this.fireContentsChanged(this, 0, JCoDirComboBox.this.dirs.length - 1);
        }

        public int getSize() {
            return JCoDirComboBox.this.dirs.length;
        }

        public Object getElementAt(int index) {
            return JCoDirComboBox.this.dirs[index];
        }

        public void setSelectedItem(Object anItem) {
            JCoDirComboBox.this.sel = (CoFile)anItem;
            if (JCoDirComboBox.this.listener != null) {
                JCoDirComboBox.this.listener.actionPerformed(new ActionEvent(this, 1001, ((Object)JCoDirComboBox.this.sel).toString()));
            }
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return JCoDirComboBox.this.sel;
        }
    }

    private class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        private IndentIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.icon != null) {
                this.icon.paintIcon(c, g, x + this.depth * 10, y);
            }
        }

        public int getIconWidth() {
            return this.depth * 10 + (this.icon != null ? this.icon.getIconWidth() : 0);
        }

        public int getIconHeight() {
            return this.icon != null ? this.icon.getIconHeight() : 1;
        }
    }

    private class DirRenderer
    extends DefaultListCellRenderer {
        IndentIcon indent;

        private DirRenderer() {
            this.indent = new IndentIcon();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof CoFile) {
                CoFile d = (CoFile)value;
                this.indent.depth = d.getPathDepth();
                JCoDirComboBox.this.installIcons();
                this.indent.icon = this.indent.depth > 0 ? JCoDirComboBox.this.directoryIcon : JCoDirComboBox.this.hardDriveIcon;
                this.setIcon(this.indent);
                if (this.indent.depth > 0) {
                    this.setText(d.getName());
                } else {
                    this.setText(d.getHost() + ((Object)d).toString());
                }
            }
            return this;
        }
    }
}

