/*
 * Decompiled with CFR 0.152.
 */
package cz.dhl.swing;

import cz.dhl.io.CoFile;
import cz.dhl.io.CoSource;
import cz.dhl.swing.JCoDirComboBox;
import cz.dhl.swing.JCoEventQueue;
import cz.dhl.swing.JCoFileTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

abstract class JCoBrowsePanel
extends JPanel {
    private final JCoDirComboBox dirChoice = new JCoDirComboBox();
    private final JCoFileTable fileList = new JCoFileTable();
    private final JScrollPane scroll = new JScrollPane(this.fileList);
    private final Border normalborder = BorderFactory.createLineBorder(Color.gray);
    private final Border activeborder = BorderFactory.createLineBorder(Color.red);
    private final JComboBox filterChoice = new JComboBox();
    private String[][] filterSs = new String[][]{new String[0], {".TXT"}, {".HTM", ".HTML", ".SHTML"}, {".CSS", ".JS", ".PL", ".PHP"}, {".CLASS", ".JAR", ".ZIP", ".CAB"}, {".GIF", ".JPG", ".PNG"}, {".H", ".C", ".HPP", ".CPP", ".JAVA"}, {".SQL", ".4GL"}, {".BAT", ".SH", ".AWK"}};
    private final JComboBox orderChoice = new JComboBox();
    private final int[] orderIs = new int[]{1, 2, 3, 4, 6};
    private JCoEventQueue queue = null;

    JCoBrowsePanel(CoSource source) {
        this.queue = JCoEventQueue.getEventQueue(source);
        this.dirChoice.setEnabled(false);
        this.fileList.setEnabled(false);
        this.filterChoice.addItem("All Files (*)");
        this.filterChoice.addItem("Text Files (txt)");
        this.filterChoice.addItem("HTML Files (htm,html,shtml)");
        this.filterChoice.addItem("Stype&Script Files (css,js,pl,php)");
        this.filterChoice.addItem("Java Class Files (class,jar,zip,cab)");
        this.filterChoice.addItem("Image Files (gif,jpg,png)");
        this.filterChoice.addItem("Source Files (h,c,hpp,cpp,java)");
        this.filterChoice.addItem("Database Query Files (sql,4gl)");
        this.filterChoice.addItem("Batch Files (bat,sh,awk)");
        this.orderChoice.addItem("Name");
        this.orderChoice.addItem("Type");
        this.orderChoice.addItem("Size");
        this.orderChoice.addItem("Date");
        this.orderChoice.addItem("None");
        JPanel toppanel = new JPanel(new BorderLayout());
        JPanel bottompanel = new JPanel(new BorderLayout());
        JPanel typepanel = new JPanel(new BorderLayout());
        JPanel orderpanel = new JPanel(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add("North", toppanel);
        toppanel.add("West", new JLabel("Look in: "));
        toppanel.add("Center", this.dirChoice);
        this.scroll.setPreferredSize(new Dimension(300, 300));
        this.scroll.setBorder(this.normalborder);
        this.add("Center", this.scroll);
        this.add("South", bottompanel);
        bottompanel.add("North", typepanel);
        typepanel.add("West", new JLabel("File Type: "));
        typepanel.add("Center", this.filterChoice);
        bottompanel.add("Center", orderpanel);
        orderpanel.add("West", new JLabel("Order by: "));
        orderpanel.add("Center", this.orderChoice);
        this.dirChoice.setDirActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCoBrowsePanel.this.queue.dirEvent();
            }
        });
        this.fileList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                JCoBrowsePanel.this.queue.statusEvent();
            }
        });
        this.fileList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    JCoBrowsePanel.this.queue.fileEvent();
                }
            }
        });
        this.fileList.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                JCoBrowsePanel.this.queue.focusEvent();
            }
        });
        this.fileList.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    JCoBrowsePanel.this.queue.fileEvent();
                }
            }
        });
        try {
            this.getClass().getMethod("getActionMap", new Class[0]);
            this.fileList.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 9) {
                        if (e.isShiftDown()) {
                            JCoBrowsePanel.this.dirChoice.requestFocus();
                        } else {
                            ((JCoBrowsePanel)JCoBrowsePanel.this).queue.oposite.browse.fileList.requestFocus();
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            // empty catch block
        }
        this.filterChoice.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCoBrowsePanel.this.filterEvent();
            }
        });
        this.orderChoice.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCoBrowsePanel.this.orderEvent();
            }
        });
    }

    void filterEvent() {
        this.fileList.setFilter(this.filterSs[this.filterChoice.getSelectedIndex()]);
    }

    void orderEvent() {
        this.fileList.setOrder(this.orderIs[this.orderChoice.getSelectedIndex()]);
    }

    public void setEnabled(boolean e) {
        this.dirChoice.setEnabled(false);
        this.fileList.setEnabled(false);
    }

    CoFile getDir() {
        return this.dirChoice.getDir();
    }

    void setDir(CoFile dir) {
        this.dirChoice.setDir(dir);
    }

    CoFile[] getFiles() {
        return this.fileList.getFiles();
    }

    void setFiles(CoFile[] files) {
        this.fileList.setFiles(files);
    }

    CoFile getSelectedDir() {
        return this.dirChoice.getSelectedDir();
    }

    public CoFile getSelectedFile() {
        return this.fileList.getSelectedFile();
    }

    public void setSelectedFile(CoFile file) {
        this.fileList.setSelectedFile(file);
    }

    public CoFile[] getSelectedFiles() {
        return this.fileList.getSelectedFiles();
    }

    public void setSelectedFiles(CoFile[] files) {
        this.fileList.setSelectedFiles(files);
    }

    void deselectAllFiles() {
        this.fileList.deselectAllFiles();
    }

    public void setActiveBorder(boolean active) {
        if (active) {
            this.scroll.setBorder(this.activeborder);
        } else {
            this.scroll.setBorder(this.normalborder);
        }
    }

    void setOpositePanel(JCoBrowsePanel oposite) {
        this.queue.oposite = oposite.queue;
    }
}

