/*
 * Decompiled with CFR 0.152.
 */
package cz.dhl.io;

import cz.dhl.io.CoFile;
import cz.dhl.io.CoFilenameFilter;
import cz.dhl.io.CoOrder;
import cz.dhl.ui.CoConsole;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public final class LocalFile
extends File
implements CoFile {
    private String name = null;
    private String ext = null;

    private void sortSetup(String name) {
        this.name = name.toUpperCase();
        int index = this.name.lastIndexOf(".");
        this.ext = index != -1 && index < this.name.length() ? this.name.substring(index) : " " + this.name;
    }

    public int compareNameToIgnoreCase(CoOrder file) {
        if (file instanceof LocalFile) {
            LocalFile l2 = (LocalFile)file;
            return this.name.compareTo(l2.name);
        }
        throw new ClassCastException();
    }

    public int compareExtToIgnoreCase(CoOrder file) {
        if (file instanceof LocalFile) {
            LocalFile l2 = (LocalFile)file;
            int result = this.ext.compareTo(l2.ext);
            if (result == 0) {
                result = this.name.compareTo(l2.name);
            }
            return result;
        }
        throw new ClassCastException();
    }

    public boolean startsWithIgnoreCase(char ch) {
        return this.name.charAt(0) == Character.toUpperCase(ch);
    }

    public boolean equalsExtTo(String filter) {
        return this.ext.compareTo(filter) == 0;
    }

    public boolean equalsExtTo(String[] filter) {
        boolean done = false;
        for (int j = 0; j < filter.length; ++j) {
            if (this.ext.compareTo(filter[j]) != 0) continue;
            done = true;
            break;
        }
        return done;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.compareTo(o) == 0;
    }

    /*
     * WARNING - void declaration
     */
    public int compareTo(Object o) {
        void var3_4;
        String s2;
        String s1 = this.getHost() + this.getAbsolutePath();
        if (o instanceof CoFile) {
            CoFile f2 = (CoFile)o;
            s2 = f2.getHost() + f2.getAbsolutePath();
        } else if (o instanceof String) {
            s2 = (String)o;
        } else {
            throw new ClassCastException();
        }
        return s1.compareTo((String)var3_4);
    }

    public boolean isConnected() {
        return true;
    }

    public char getDataType() {
        return 'I';
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this);
    }

    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this);
    }

    public OutputStream getOutputStream(boolean append) throws IOException {
        return new FileOutputStream(this.toString(), append);
    }

    public CoFile newFileChild(String child) {
        return new LocalFile(this, child);
    }

    public CoFile newFileRename(String name) {
        return new LocalFile(this.getParent(), name);
    }

    public CoConsole getConsole() {
        return null;
    }

    public LocalFile(String path) {
        super(path);
        this.sortSetup(this.getName());
    }

    public LocalFile(String path, String name) {
        super(path, name);
        this.sortSetup(name);
    }

    public LocalFile(LocalFile dir, String name) {
        super(dir, name);
        this.sortSetup(name);
    }

    public String getHost() {
        return "";
    }

    public int getPathDepth() {
        String path = this.getAbsolutePath();
        int depth = -1;
        int length = -1;
        while ((length = path.indexOf(File.separatorChar, length + 1)) >= 0) {
            ++depth;
        }
        if (!path.endsWith(File.separator)) {
            ++depth;
        }
        return depth;
    }

    public CoFile getPathFragment(int depth) {
        String path = this.getAbsolutePath();
        if (depth > 0) {
            int length = -1;
            for (int n = 0; n <= depth && (length = path.indexOf(File.separatorChar, length + 1)) >= 0; ++n) {
            }
            if (length > 0) {
                return new LocalFile(path.substring(0, length));
            }
            return this;
        }
        return new LocalFile(path.substring(0, path.indexOf(File.separatorChar) + 1));
    }

    public String[] getPathArray() {
        Vector<String> dv = new Vector<String>();
        String path = this.getAbsolutePath();
        if (path != null) {
            StringTokenizer tokenizer = new StringTokenizer(path, File.separator);
            try {
                while (true) {
                    String d = tokenizer.nextToken();
                    dv.addElement(d);
                }
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
        }
        Object[] ds = new String[dv.size()];
        dv.copyInto(ds);
        return ds;
    }

    public String getName() {
        return super.getName();
    }

    public String getParent() {
        return super.getParent();
    }

    public boolean delete() throws SecurityException {
        return super.delete();
    }

    public boolean mkdir() throws SecurityException {
        return super.mkdir();
    }

    public boolean mkdirs() throws SecurityException {
        return super.mkdirs();
    }

    public boolean renameTo(CoFile dest) throws SecurityException {
        return super.renameTo((File)((Object)dest));
    }

    public String lastModifiedString() {
        return DateFormat.getDateTimeInstance(3, 3).format(new Date(this.lastModified()));
    }

    public long length() {
        return super.length();
    }

    public long lastModified() {
        return super.lastModified();
    }

    public boolean isAbsolute() {
        return super.isAbsolute();
    }

    public boolean isDirectory() {
        return super.isDirectory();
    }

    public boolean isFile() {
        return super.isFile();
    }

    public boolean isSpecial() {
        return false;
    }

    public boolean isLink() {
        return false;
    }

    public boolean isHidden() {
        try {
            Class.forName("java.io.File").getMethod("isHidden", new Class[0]);
            return super.isHidden();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean canRead() {
        return super.canRead();
    }

    public boolean canWrite() {
        return super.canWrite();
    }

    public boolean exists() {
        return super.exists();
    }

    public String getAccess() {
        String access = null;
        access = this.isDirectory() ? "d" : "-";
        access = this.canRead() ? access + "r" : access + "-";
        access = this.canWrite() ? access + "w?" : access + "-?";
        return access;
    }

    public String propertyString() {
        return (this.isFile() ? "" + this.length() + " " : "") + this.getAccess();
    }

    public CoFile[] listCoRoots() {
        try {
            Class.forName("java.io.File").getMethod("listRoots", new Class[0]);
            File[] ls = File.listRoots();
            if (ls == null) {
                return null;
            }
            CoFile[] fs = new LocalFile[ls.length];
            for (int i = 0; i < ls.length; ++i) {
                fs[i] = new LocalFile(ls[i].getAbsolutePath());
            }
            return fs;
        }
        catch (Exception e) {
            CoFile[] fs = new CoFile[]{this.getPathFragment(0)};
            return fs;
        }
    }

    public CoFile[] listCoFiles() throws SecurityException {
        String[] ss = this.list();
        if (ss == null) {
            return null;
        }
        CoFile[] fs = new LocalFile[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            fs[i] = new LocalFile(this.getAbsolutePath(), ss[i]);
        }
        return fs;
    }

    public CoFile[] listCoFiles(CoFilenameFilter filter) throws SecurityException {
        Object[] fs = (LocalFile[])this.listCoFiles();
        if (fs == null) {
            return null;
        }
        if (filter != null) {
            Vector<Object> fv = new Vector<Object>();
            for (int i = 0; i < fs.length; ++i) {
                if (!filter.accept(this, ((LocalFile)fs[i]).getName())) continue;
                fv.addElement(fs[i]);
            }
            fs = new LocalFile[fv.size()];
            fv.copyInto(fs);
        }
        return fs;
    }

    public String toString() {
        return this.getAbsolutePath();
    }
}

