/*
 * Decompiled with CFR 0.152.
 */
package cz.dhl.io;

import cz.dhl.io.CoFile;
import cz.dhl.io.CoLoad;
import cz.dhl.ui.CoConsole;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

final class CoTextLoad
extends CoLoad {
    private BufferedReader ibuf = null;
    private BufferedWriter obuf = null;

    CoTextLoad(CoFile dst, CoFile src, CoConsole console) throws IOException {
        this.console = console;
        try {
            this.ibuf = new BufferedReader(new InputStreamReader(src.getInputStream()));
            this.obuf = new BufferedWriter(new OutputStreamWriter(dst.getOutputStream()));
        }
        catch (IOException e) {
            if (this.ibuf == null) {
                console.print("< Can't obtain INPUT STREAM for '" + src.getName() + "'! >");
            } else if (this.obuf == null) {
                console.print("< Can't obtain OUTPUT STREAM for '" + dst.getName() + "'! >");
            }
            this.close();
            throw e;
        }
    }

    public int transfer() throws IOException {
        String line = null;
        line = this.ibuf.readLine();
        if (line != null) {
            this.obuf.write(line);
            this.obuf.newLine();
            return line.length();
        }
        return -1;
    }

    public void close() throws IOException {
        IOException x = null;
        while (this.ibuf != null || this.obuf != null) {
            try {
                if (this.ibuf != null) {
                    BufferedReader r = this.ibuf;
                    this.ibuf = null;
                    ((Reader)r).close();
                }
                if (this.obuf == null) continue;
                BufferedWriter w = this.obuf;
                this.obuf = null;
                ((Writer)w).close();
            }
            catch (IOException e) {
                x = e;
            }
        }
        if (x != null) {
            throw x;
        }
    }
}

