/*
 * Decompiled with CFR 0.152.
 */
package cz.dhl.io;

import cz.dhl.io.CoFile;
import java.util.Date;
import java.util.Vector;

public class CoSort {
    private int sorttype;
    public static final int ORDER_BY_NAME = 1;
    public static final int ORDER_BY_TYPE = 2;
    public static final int ORDER_BY_SIZE = 3;
    public static final int ORDER_BY_DATE = 4;
    public static final int ORDER_BY_PATH = 5;
    public static final int ORDER_BY_NONE = 6;
    public static final int ORDER_INVERSE = 8;

    CoSort(int sorttype) {
        this.sorttype = sorttype;
    }

    private boolean Pause() throws Exception {
        return true;
    }

    private void Swap(CoFile[] a, int i, int j) {
        CoFile T = a[i];
        a[i] = a[j];
        a[j] = T;
    }

    private boolean AgreaterB(CoFile a, CoFile b) {
        boolean compare = false;
        switch (this.sorttype) {
            case 1: {
                compare = a.compareNameToIgnoreCase(b) > 0;
                break;
            }
            case 2: {
                compare = a.compareExtToIgnoreCase(b) > 0;
                break;
            }
            case 3: {
                compare = a.length() > b.length();
                break;
            }
            case 4: {
                compare = new Date(a.lastModified()).after(new Date(b.lastModified()));
                break;
            }
            case 5: {
                compare = a.compareTo(b) > 0;
            }
        }
        return compare;
    }

    private boolean AsmallerB(CoFile a, CoFile b) {
        boolean compare = false;
        switch (this.sorttype) {
            case 1: {
                compare = a.compareNameToIgnoreCase(b) < 0;
                break;
            }
            case 2: {
                compare = a.compareExtToIgnoreCase(b) < 0;
                break;
            }
            case 3: {
                compare = a.length() < b.length();
                break;
            }
            case 4: {
                compare = new Date(a.lastModified()).before(new Date(b.lastModified()));
                break;
            }
            case 5: {
                compare = a.compareTo(b) < 0;
            }
        }
        return compare;
    }

    private void QuickSort(CoFile[] a, int lo0, int hi0) throws Exception {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            CoFile mid = a[(lo0 + hi0) / 2];
            while (lo <= hi) {
                while (lo < hi0 && this.Pause() && this.AsmallerB(a[lo], mid)) {
                    ++lo;
                }
                while (hi > lo0 && this.Pause() && this.AgreaterB(a[hi], mid)) {
                    --hi;
                }
                if (lo > hi) continue;
                this.Swap(a, lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                this.QuickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                this.QuickSort(a, lo, hi0);
            }
        }
    }

    private void Sort(CoFile[] a) throws Exception {
        this.QuickSort(a, 0, a.length - 1);
        if ((this.sorttype & 8) > 0) {
            for (int n = 0; n < a.length / 2; ++n) {
                this.Swap(a, n, a.length - 1 - n);
            }
        }
    }

    public static CoFile[] listFilter(CoFile[] list, String[] filter) {
        if (filter.length != 0) {
            Vector<CoFile> ffv = new Vector<CoFile>();
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].isDirectory() && !list[i].isLink() && !list[i].equalsExtTo(filter)) continue;
                ffv.addElement(list[i]);
            }
            Object[] ffs = new CoFile[ffv.size()];
            ffv.copyInto(ffs);
            return ffs;
        }
        return list;
    }

    public static CoFile[] listOrder(CoFile[] list, int sorttype) {
        if ((sorttype & 0xFFFFFFF7) != 6) {
            CoSort s = new CoSort(sorttype);
            try {
                s.Sort(list);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return list;
        }
        return list;
    }

    public static CoFile[] listSplit(CoFile[] list) {
        int i;
        Vector<CoFile> ffv = new Vector<CoFile>();
        for (i = 0; i < list.length; ++i) {
            if (!list[i].isDirectory() && !list[i].isLink()) continue;
            ffv.addElement(list[i]);
        }
        for (i = 0; i < list.length; ++i) {
            if (list[i].isDirectory() || list[i].isLink()) continue;
            ffv.addElement(list[i]);
        }
        Object[] ffs = new CoFile[ffv.size()];
        ffv.copyInto(ffs);
        return ffs;
    }
}

