/*
 * Decompiled with CFR 0.152.
 */
package cz.dhl.io;

import cz.dhl.io.CoDataLoad;
import cz.dhl.io.CoFile;
import cz.dhl.io.CoProgressNull;
import cz.dhl.io.CoTextLoad;
import cz.dhl.ui.CoConsole;
import cz.dhl.ui.CoProgress;
import java.io.IOException;

public abstract class CoLoad {
    CoConsole console;

    CoLoad() {
    }

    public static boolean delete(CoFile[] files) {
        return CoLoad.delete(files, new CoProgressNull());
    }

    public static boolean delete(CoFile[] files, CoProgress progress) {
        boolean done = true;
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory()) {
                    if (progress.isAborted()) {
                        done = false;
                        break;
                    }
                    progress.setFile(files[i]);
                    if (files[i].delete()) continue;
                    done = false;
                    break;
                }
                if (!files[i].isDirectory()) continue;
                try {
                    if (progress.isAborted()) {
                        done = false;
                        break;
                    }
                    progress.setFile(files[i]);
                    if (!CoLoad.delete(files[i].listCoFiles(), progress)) {
                        done = false;
                        break;
                    }
                    if (files[i].delete()) continue;
                    done = false;
                }
                catch (SecurityException e) {
                    done = false;
                }
                break;
            }
        }
        return done;
    }

    public static boolean copy(CoFile to, CoFile[] files) {
        return CoLoad.copy(to, files, (CoProgress)new CoProgressNull());
    }

    public static boolean copy(CoFile to, CoFile[] files, CoProgress progress) {
        boolean done = true;
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isFile()) {
                    if (progress.isAborted()) {
                        done = false;
                        break;
                    }
                    CoFile tofile = to.newFileChild(files[i].getName());
                    progress.setFile(tofile, files[i]);
                    if (CoLoad.copy(tofile, files[i], progress)) continue;
                    done = false;
                    break;
                }
                if (!files[i].isDirectory()) continue;
                try {
                    if (progress.isAborted()) {
                        done = false;
                        break;
                    }
                    CoFile todir = to.newFileChild(files[i].getName());
                    progress.setFile(todir, files[i]);
                    todir.mkdir();
                    if (CoLoad.copy(to.newFileChild(files[i].getName()), files[i].listCoFiles(), progress)) continue;
                    done = false;
                }
                catch (SecurityException e) {
                    done = false;
                }
                break;
            }
        }
        return done;
    }

    public static boolean copy(CoFile dst, CoFile file) {
        return CoLoad.copy(dst, file, (CoProgress)new CoProgressNull());
    }

    public static boolean copy(CoFile dst, CoFile file, CoProgress progress) {
        CoConsole console = null;
        if (dst.getConsole() != null) {
            console = dst.getConsole();
        } else if (file.getConsole() != null) {
            console = file.getConsole();
        } else if (console == null) {
            console = new CoConsole(){

                public void print(String message) {
                }
            };
        }
        return CoLoad.copy(dst, file, progress, console);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean copy(CoFile dst, CoFile file, CoProgress progress, CoConsole console) {
        boolean done;
        block15: {
            done = false;
            CoLoad load = null;
            load = CoLoad.open(dst, file, console);
            int increment = 0;
            while (increment != -1) {
                if (progress.isAborted()) {
                    done = false;
                    break;
                }
                try {
                    increment = load.transfer();
                }
                catch (IOException e) {
                    progress.setDelay(60000L);
                    increment = 0;
                }
                if (increment == -1) continue;
                progress.setProgress(increment);
            }
            done = true;
            Object var9_9 = null;
            try {
                if (load != null) {
                    load.close();
                }
                break block15;
            }
            catch (IOException e2) {}
            break block15;
            {
                catch (IOException e) {
                    Object var9_10 = null;
                    try {
                        if (load != null) {
                            load.close();
                        }
                        break block15;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (load != null) {
                        load.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return done;
    }

    static CoLoad open(CoFile dst, CoFile src, CoConsole console) throws IOException {
        if (dst.getDataType() == 'A' || src.getDataType() == 'A') {
            return new CoTextLoad(dst, src, console);
        }
        return new CoDataLoad(dst, src, console);
    }

    abstract int transfer() throws IOException;

    abstract void close() throws IOException;
}

