/*
 * Decompiled with CFR 0.152.
 */
package cz.dhl.io;

import cz.dhl.io.CoFile;
import cz.dhl.io.CoLoad;
import cz.dhl.ui.CoConsole;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class CoDataLoad
extends CoLoad {
    private byte[] cbuf = new byte[4096];
    private InputStream ibuf = null;
    private OutputStream obuf = null;

    CoDataLoad(CoFile dst, CoFile src, CoConsole console) throws IOException {
        this.console = console;
        try {
            this.ibuf = new BufferedInputStream(src.getInputStream());
            this.obuf = new BufferedOutputStream(dst.getOutputStream());
        }
        catch (IOException e) {
            if (this.ibuf == null) {
                console.print("< Can't obtain INPUT STREAM for '" + src.getName() + "'! >");
            } else if (this.obuf == null) {
                console.print("< Can't obtain OUTPUT STREAM for '" + dst.getName() + "'! >");
            }
            this.close();
            throw e;
        }
    }

    public int transfer() throws IOException {
        int len = this.ibuf.read(this.cbuf, 0, 4096);
        if (len > 0) {
            this.obuf.write(this.cbuf, 0, len);
        }
        return len;
    }

    public void close() throws IOException {
        IOException ex = null;
        while (this.ibuf != null || this.obuf != null) {
            try {
                if (this.ibuf != null) {
                    InputStream i = this.ibuf;
                    this.ibuf = null;
                    i.close();
                }
                if (this.obuf == null) continue;
                OutputStream o = this.obuf;
                this.obuf = null;
                o.close();
            }
            catch (IOException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }
}

