/*
 * Decompiled with CFR 0.152.
 */
package cz.dhl.ftp;

import cz.dhl.ftp.Ftp;
import cz.dhl.ftp.FtpConnect;
import cz.dhl.ftp.FtpDataSocket;
import cz.dhl.ftp.FtpFile;
import cz.dhl.ui.CoConsole;
import java.io.IOException;
import java.io.OutputStream;

public final class FtpOutputStream
extends OutputStream {
    private Ftp client;
    private FtpDataSocket data;
    private OutputStream stream;

    public FtpOutputStream(FtpFile file) throws IOException {
        this(file, false);
    }

    public FtpOutputStream(FtpFile file, boolean append) throws IOException {
        this.client = null;
        this.data = new FtpDataSocket(file.client);
        this.stream = append ? this.data.getOutputStream("APPE " + file, file.getDataType()) : this.data.getOutputStream("STOR " + file, file.getDataType());
    }

    public FtpOutputStream(FtpFile file, FtpConnect connect, CoConsole console) throws IOException {
        this(file, connect, console, false);
    }

    public FtpOutputStream(FtpFile file, FtpConnect connect, CoConsole console, boolean append) throws IOException {
        this.client = new Ftp();
        if (this.client.connect(connect)) {
            if (console != null) {
                this.client.getContext().setConsole(console);
            }
            file = new FtpFile(file.toString(), this.client);
            this.data = new FtpDataSocket(file.client);
            this.stream = append ? this.data.getOutputStream("APPE " + file, file.getDataType()) : this.data.getOutputStream("STOR " + file, file.getDataType());
        } else {
            throw new IOException("Connect failed.");
        }
    }

    public void close() throws IOException {
        IOException x = null;
        while (this.stream != null || this.data != null || this.client != null) {
            try {
                if (this.stream != null) {
                    OutputStream o = this.stream;
                    this.stream = null;
                    o.close();
                }
                if (this.data != null) {
                    FtpDataSocket d = this.data;
                    this.data = null;
                    d.close();
                }
                if (this.client == null) continue;
                Ftp c = this.client;
                this.client = null;
                c.disconnect();
            }
            catch (IOException e) {
                x = e;
            }
        }
        if (x != null) {
            throw x;
        }
    }

    public void write(int b) throws IOException {
        this.stream.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.stream.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.stream.write(b, off, len);
    }

    public void flush() throws IOException {
        this.stream.flush();
    }
}

