/*
 * Decompiled with CFR 0.152.
 */
package cz.dhl.ftp;

import cz.dhl.ftp.FtpDataSocket;
import cz.dhl.ftp.FtpFile;
import cz.dhl.ftp.FtpInputStream;
import java.io.IOException;

public final class FtpListInputStream
extends FtpInputStream {
    public FtpListInputStream(FtpFile dir) throws IOException {
        String command = null;
        if (!dir.client.cd(dir.toString())) {
            throw new IOException("File: cd command failed!\ncd " + dir);
        }
        dir.path = dir.client.pwd();
        this.data = new FtpDataSocket(dir.client);
        switch (this.data.context.getListCommandMode()) {
            case 1: {
                command = "LIST";
                break;
            }
            case 2: {
                command = "NLST";
                break;
            }
            case 4: {
                command = "NLST -F";
                break;
            }
            case 3: {
                command = "NLST -p";
                break;
            }
            case 5: {
                command = "NLST -la";
                break;
            }
            default: {
                throw new IOException("File: Invalid List Command Mode!");
            }
        }
        this.stream = this.data.getInputStream(command, 'A');
    }
}

