/*
 * Decompiled with CFR 0.152.
 */
package cz.dhl.ftp;

import java.util.Hashtable;

final class FtpInterpret {
    private static final String[] notAllow;
    private static final String[] notManual;
    private static final Hashtable library;

    static boolean startsWith(String string, String[] prefixes) {
        boolean done = false;
        for (int i = 0; i < prefixes.length; ++i) {
            if (string.indexOf(prefixes[i]) != 0) continue;
            done = true;
            break;
        }
        return done;
    }

    protected FtpInterpret() {
    }

    static String getCommand(String commandline) {
        return commandline.substring(0, commandline.indexOf(" ") >= 0 && commandline.indexOf(" ") <= 4 ? commandline.indexOf(" ") : commandline.length());
    }

    static void putReplies(String command, String[] replies) {
        library.put(command, replies);
    }

    static String[] getReplies(String commandline) {
        String command = FtpInterpret.getCommand(commandline);
        String[] replies = (String[])library.get(command);
        if (replies == null) {
            replies = new String[]{};
        }
        return replies;
    }

    static boolean allowExecution(String commandline) {
        return !FtpInterpret.startsWith(commandline, notAllow);
    }

    static boolean allowManualExecution(String commandline) {
        return !FtpInterpret.startsWith(commandline, notManual);
    }

    static {
        library = new Hashtable();
        String[] loginok = new String[]{"220"};
        FtpInterpret.putReplies("login-done", loginok);
        String[] userok = new String[]{"230", "331"};
        FtpInterpret.putReplies("USER", userok);
        String[] skipok = new String[]{"230"};
        FtpInterpret.putReplies("USER-done", skipok);
        String[] passok = new String[]{"230", "202"};
        FtpInterpret.putReplies("PASS", passok);
        String[] listok = new String[]{"125", "150"};
        FtpInterpret.putReplies("RETR", listok);
        FtpInterpret.putReplies("STOR", listok);
        FtpInterpret.putReplies("STOU", listok);
        FtpInterpret.putReplies("APPE", listok);
        FtpInterpret.putReplies("LIST", listok);
        FtpInterpret.putReplies("NLST", listok);
        String[] doneok = new String[]{"226", "250"};
        FtpInterpret.putReplies("data-done", doneok);
        String[] aborok = new String[]{"225"};
        FtpInterpret.putReplies("ABOR", aborok);
        String[] typeok = new String[]{"200"};
        FtpInterpret.putReplies("TYPE", typeok);
        FtpInterpret.putReplies("PORT", typeok);
        String[] cwdok = new String[]{"250"};
        FtpInterpret.putReplies("CWD", cwdok);
        FtpInterpret.putReplies("CDUP", cwdok);
        FtpInterpret.putReplies("RMD", cwdok);
        FtpInterpret.putReplies("DELE", cwdok);
        String[] rnfrok = new String[]{"350"};
        FtpInterpret.putReplies("RNFR", rnfrok);
        FtpInterpret.putReplies("RNTO", cwdok);
        String[] mkdok = new String[]{"257"};
        FtpInterpret.putReplies("MKD", mkdok);
        FtpInterpret.putReplies("PWD", mkdok);
        String[] systok = new String[]{"215"};
        FtpInterpret.putReplies("SYST", systok);
        String[] quitok = new String[]{"221"};
        FtpInterpret.putReplies("QUIT", quitok);
        String[] pasvok = new String[]{"227"};
        FtpInterpret.putReplies("PASV", pasvok);
        String[] nA = new String[]{"REST", "MODE", "STRU"};
        notAllow = nA;
        String[] nM = new String[]{"PORT", "TYPE", "RETR", "STOR", "STOU", "APPE", "LIST", "NLST", "USER", "PASS", "QUIT", "PASV"};
        notManual = nM;
    }
}

