/*
 * Decompiled with CFR 0.152.
 */
package cz.dhl.ftp;

import cz.dhl.ftp.Ftp;
import cz.dhl.ftp.FtpConnect;
import cz.dhl.ftp.FtpDataSocket;
import cz.dhl.ftp.FtpFile;
import cz.dhl.ui.CoConsole;
import java.io.IOException;
import java.io.InputStream;

public class FtpInputStream
extends InputStream {
    Ftp client;
    FtpDataSocket data;
    InputStream stream;

    FtpInputStream() {
    }

    public FtpInputStream(FtpFile file) throws IOException {
        this.client = null;
        this.data = new FtpDataSocket(file.client);
        this.stream = this.data.getInputStream("RETR " + file, file.getDataType());
    }

    public FtpInputStream(FtpFile file, FtpConnect connect, CoConsole console) throws IOException {
        this.client = new Ftp();
        if (this.client.connect(connect)) {
            if (console != null) {
                this.client.getContext().setConsole(console);
            }
        } else {
            throw new IOException("Connect failed.");
        }
        file = new FtpFile(file.toString(), this.client);
        this.data = new FtpDataSocket(file.client);
        this.stream = this.data.getInputStream("RETR " + file, file.getDataType());
    }

    public void close() throws IOException {
        IOException x = null;
        while (this.stream != null || this.data != null || this.client != null) {
            try {
                if (this.stream != null) {
                    InputStream i = this.stream;
                    this.stream = null;
                    i.close();
                }
                if (this.data != null) {
                    FtpDataSocket d = this.data;
                    this.data = null;
                    d.close();
                }
                if (this.client == null) continue;
                Ftp c = this.client;
                this.client = null;
                c.disconnect();
            }
            catch (IOException e) {
                x = e;
            }
        }
        if (x != null) {
            throw x;
        }
    }

    public int read() throws IOException {
        return this.stream.read();
    }

    public int read(byte[] b) throws IOException {
        return this.stream.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.stream.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        return this.stream.skip(n);
    }

    public int available() throws IOException {
        return this.stream.available();
    }

    public synchronized void mark(int readlimit) {
        this.stream.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        this.stream.reset();
    }

    public boolean markSupported() {
        return this.stream.markSupported();
    }
}

