/*
 * Decompiled with CFR 0.152.
 */
package cz.dhl.ftp;

import cz.dhl.ftp.Ftp;
import cz.dhl.ftp.FtpInputStream;
import cz.dhl.ftp.FtpListInputStream;
import cz.dhl.ftp.FtpOutputStream;
import cz.dhl.io.CoFile;
import cz.dhl.io.CoFilenameFilter;
import cz.dhl.io.CoOrder;
import cz.dhl.ui.CoConsole;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public final class FtpFile
implements CoFile {
    private String name = null;
    private String ext = null;
    private static final String[] months = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
    private static final char LINK = 'l';
    private static final char SPECIAL = 'c';
    private static final char FOLDER = 'd';
    private static final char FILE = '-';
    Ftp client = null;
    private String access = null;
    private String owner = null;
    private String group = null;
    private long size = 0L;
    private long date = 0L;
    String path = null;

    private void sortSetup(String name) {
        this.name = name.toUpperCase();
        int index = this.name.lastIndexOf(".");
        this.ext = index != -1 && index < this.name.length() ? this.name.substring(index) : " " + this.name;
    }

    public int compareNameToIgnoreCase(CoOrder file) {
        if (file instanceof FtpFile) {
            FtpFile l2 = (FtpFile)file;
            return this.name.compareTo(l2.name);
        }
        throw new ClassCastException();
    }

    public int compareExtToIgnoreCase(CoOrder file) {
        if (file instanceof FtpFile) {
            FtpFile l2 = (FtpFile)file;
            int result = this.ext.compareTo(l2.ext);
            if (result == 0) {
                result = this.name.compareTo(l2.name);
            }
            return result;
        }
        throw new ClassCastException();
    }

    public boolean startsWithIgnoreCase(char ch) {
        return this.name.charAt(0) == Character.toUpperCase(ch);
    }

    public boolean equalsExtTo(String filter) {
        return this.ext.compareTo(filter) == 0;
    }

    public boolean equalsExtTo(String[] filter) {
        boolean done = false;
        for (int j = 0; j < filter.length; ++j) {
            if (this.ext.compareTo(filter[j]) != 0) continue;
            done = true;
            break;
        }
        return done;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.compareTo(o) == 0;
    }

    /*
     * WARNING - void declaration
     */
    public int compareTo(Object o) {
        void var3_4;
        String s2;
        String s1 = this.getHost() + this.getAbsolutePath();
        if (o instanceof CoFile) {
            CoFile f2 = (CoFile)o;
            s2 = f2.getHost() + f2.getAbsolutePath();
        } else if (o instanceof String) {
            s2 = (String)o;
        } else {
            throw new ClassCastException();
        }
        return s1.compareTo((String)var3_4);
    }

    public boolean isConnected() {
        return this.client.isConnected();
    }

    public char getDataType() {
        if (this.client.getContext().getFileTransferMode() == 'S') {
            if (this.equalsExtTo(this.client.getContext().getTextFilter())) {
                return 'A';
            }
            return 'I';
        }
        return this.client.getContext().getFileTransferMode();
    }

    public InputStream getInputStream() throws IOException {
        return new FtpInputStream(this);
    }

    public OutputStream getOutputStream() throws IOException {
        return new FtpOutputStream(this, false);
    }

    public OutputStream getOutputStream(boolean append) throws IOException {
        return new FtpOutputStream(this, append);
    }

    public CoFile newFileChild(String child) {
        return new FtpFile(this, child, this.client);
    }

    public CoFile newFileRename(String name) {
        return new FtpFile(this.getParent(), name, this.client);
    }

    public CoConsole getConsole() {
        return this.client.getContext().getConsole();
    }

    private FtpFile() {
    }

    public FtpFile(String path, Ftp client) {
        this.access = "d?????????";
        this.owner = "";
        this.group = "";
        this.size = -1L;
        this.date = 0L;
        this.path = path.compareTo("/") != 0 && path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
        this.client = client;
        this.sortSetup(this.getName());
    }

    public FtpFile(String path, String name, Ftp client) {
        this.access = "f?????????";
        this.owner = "";
        this.group = "";
        this.size = -1L;
        this.date = 0L;
        this.path = path.endsWith("/") ? path + name : path + "/" + name;
        this.client = client;
        this.sortSetup(name);
    }

    public FtpFile(FtpFile dir, String name, Ftp client) {
        this(dir.toString(), name, client);
    }

    public String getHost() {
        String system = "";
        try {
            system = this.client.host();
        }
        catch (IOException e) {
            this.client.getContext().printlog("< File: Can't obtain host name. >\n" + e);
        }
        return system;
    }

    public String getAbsolutePath() {
        return this.path;
    }

    public int getPathDepth() {
        int depth = -1;
        int length = -1;
        while ((length = this.path.indexOf(47, length + 1)) >= 0) {
            ++depth;
        }
        if (!this.path.endsWith("/")) {
            ++depth;
        }
        return depth;
    }

    public CoFile getPathFragment(int depth) {
        if (depth > 0) {
            int length = -1;
            for (int n = 0; n <= depth && (length = this.path.indexOf(47, length + 1)) >= 0; ++n) {
            }
            if (length > 0) {
                return new FtpFile(this.path.substring(0, length), this.client);
            }
            return this;
        }
        return new FtpFile("/", this.client);
    }

    public String[] getPathArray() {
        Vector<String> dv = new Vector<String>();
        dv.addElement(this.getHost());
        StringTokenizer toker = new StringTokenizer(this.path, "/");
        try {
            while (true) {
                String d = toker.nextToken();
                dv.addElement(d);
            }
        }
        catch (NoSuchElementException e) {
            Object[] ds = new String[dv.size()];
            dv.copyInto(ds);
            return ds;
        }
    }

    public String getName() {
        if (this.path.lastIndexOf(47) >= 0) {
            return this.path.substring(this.path.lastIndexOf(47) + 1);
        }
        return this.path;
    }

    public String getParent() {
        if (this.path.lastIndexOf(47) > 0) {
            return this.path.substring(0, this.path.lastIndexOf(47));
        }
        return new String("/");
    }

    public boolean delete() throws SecurityException {
        if (this.isDirectory()) {
            this.client.cd(this.getParent());
            if (this.client.rmdir(this.path)) {
                return true;
            }
            return this.client.rm(this.path);
        }
        if (this.client.rm(this.path)) {
            return true;
        }
        this.client.cd(this.getParent());
        return this.client.rmdir(this.path);
    }

    public boolean mkdir() throws SecurityException {
        return this.client.mkdir(this.path);
    }

    public boolean mkdirs() throws SecurityException {
        boolean done = true;
        int depth = this.getPathDepth();
        for (int i = 0; i < depth; ++i) {
            done = ((FtpFile)this.getPathFragment(i)).mkdir();
        }
        return done;
    }

    public boolean renameTo(CoFile dest) throws SecurityException {
        return this.client.mv(this.path, dest.getAbsolutePath());
    }

    public long length() {
        return this.size;
    }

    public long lastModified() {
        return this.date;
    }

    public String lastModifiedString() {
        return DateFormat.getDateTimeInstance(3, 3).format(new Date(this.lastModified()));
    }

    public boolean isAbsolute() {
        return this.path.charAt(0) == '/';
    }

    public boolean isDirectory() {
        return this.access.charAt(0) == 'd';
    }

    public boolean isFile() {
        return this.access.charAt(0) == '-';
    }

    public boolean isSpecial() {
        return this.access.charAt(0) == 'c';
    }

    public boolean isLink() {
        return this.access.charAt(0) == 'l';
    }

    public boolean isExecutable() {
        return this.access.indexOf(120) != -1;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }

    public boolean exists() {
        return false;
    }

    public String getAccess() {
        return this.access;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getGroup() {
        return this.group;
    }

    public String propertyString() {
        String desc = this.getAccess() + " " + this.getOwner() + " " + this.getGroup();
        return this.isFile() ? "" + this.length() + " " + desc : desc;
    }

    public CoFile[] listCoRoots() {
        CoFile[] fs = new FtpFile[]{this.getPathFragment(0)};
        return fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public CoFile[] listCoFiles() throws SecurityException {
        Object[] fs;
        block21: {
            String line;
            fs = null;
            Reader ibuf = null;
            int listtype = this.client.getContext().getListCommandMode();
            boolean error = false;
            Vector<FtpFile> fv = new Vector<FtpFile>();
            ibuf = new BufferedReader(new InputStreamReader(new FtpListInputStream(this)));
            while ((line = ((BufferedReader)ibuf).readLine()) != null) {
                try {
                    switch (listtype) {
                        case 1: {
                            fv.addElement(FtpFile.examineListLine(this, line));
                            break;
                        }
                        case 2: {
                            if (line.startsWith("/") && line.endsWith(":")) break;
                            if (line.indexOf("//") != -1) {
                                line = line.substring(line.lastIndexOf(47) + 1);
                            }
                        }
                        case 3: 
                        case 4: {
                            if (line.length() <= 0) break;
                            fv.addElement(FtpFile.examineNameListLine(this, line, listtype));
                            break;
                        }
                        case 5: {
                            fv.addElement(FtpFile.examineUnixListLine(this, line));
                        }
                    }
                }
                catch (NoSuchElementException e) {
                    if (error || e.getMessage() != null && e.getMessage().equals("skip")) continue;
                    this.client.printlog("\n   < File: Invalid List Format ! >" + (e.getMessage() != null ? "\n   " + e.getMessage() : "") + "\n   Line: " + line + "\n   Try: 'NAME_LIST' List Command");
                    error = true;
                }
            }
            fs = new FtpFile[fv.size()];
            fv.copyInto(fs);
            Object var9_9 = null;
            try {
                if (ibuf != null) {
                    Reader r = ibuf;
                    ibuf = null;
                    r.close();
                }
                break block21;
            }
            catch (IOException e2) {
                this.client.printerr(e2);
            }
            break block21;
            {
                catch (IOException e) {
                    this.client.printlog("< File: Can't list directory! >\n" + e);
                    Object var9_10 = null;
                    try {
                        if (ibuf != null) {
                            Reader r = ibuf;
                            ibuf = null;
                            r.close();
                        }
                        break block21;
                    }
                    catch (IOException e2) {
                        this.client.printerr(e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (ibuf != null) {
                        Reader r = ibuf;
                        ibuf = null;
                        r.close();
                    }
                }
                catch (IOException e2) {
                    this.client.printerr(e2);
                }
                throw throwable;
            }
        }
        return fs;
    }

    public CoFile[] listCoFiles(CoFilenameFilter filter) throws SecurityException {
        Object[] fs = (FtpFile[])this.listCoFiles();
        if (fs == null) {
            return null;
        }
        if (filter != null) {
            Vector<Object> fv = new Vector<Object>();
            for (int i = 0; i < fs.length; ++i) {
                if (!filter.accept(this, ((FtpFile)fs[i]).getName())) continue;
                fv.addElement(fs[i]);
            }
            fs = new FtpFile[fv.size()];
            fv.copyInto(fs);
        }
        return fs;
    }

    private static FtpFile examineListLine(FtpFile path, String line) throws NoSuchElementException {
        if ("0123456789".indexOf(line.charAt(0)) < 0) {
            return FtpFile.examineUnixListLine(path, line);
        }
        return FtpFile.examineWinListLine(path, line);
    }

    private static FtpFile examineNameListLine(FtpFile path, String line, int listtype) throws NoSuchElementException {
        FtpFile ff = new FtpFile();
        ff.client = path.client;
        switch (listtype) {
            case 2: {
                if (line.indexOf(46) != -1) {
                    ff.access = "-?????????";
                    break;
                }
                ff.access = "d?????????";
                break;
            }
            case 3: {
                if (line.endsWith("/")) {
                    ff.access = "d?????????";
                    line = line.substring(0, line.length() - 1);
                    break;
                }
                ff.access = "-?????????";
                break;
            }
            case 4: {
                if (line.endsWith("/")) {
                    ff.access = "d?????????";
                    line = line.substring(0, line.length() - 1);
                    break;
                }
                if (line.endsWith("*")) {
                    ff.access = "-??x??x??x";
                    line = line.substring(0, line.length() - 1);
                    break;
                }
                if (line.endsWith("@")) {
                    ff.access = "l?????????";
                    line = line.substring(0, line.length() - 1);
                    break;
                }
                ff.access = "-?????????";
            }
        }
        ff.owner = "";
        ff.group = "";
        ff.size = -1L;
        ff.date = 0L;
        ff.path = path.getAbsolutePath();
        ff.path = !ff.path.endsWith("/") ? ff.path + '/' + line : ff.path + line;
        ff.sortSetup(line);
        if (ff.getName().compareTo(".") == 0 || ff.getName().compareTo("..") == 0) {
            throw new NoSuchElementException("skip");
        }
        return ff;
    }

    private static FtpFile examineWinListLine(FtpFile path, String line) throws NoSuchElementException {
        FtpFile ff = new FtpFile();
        ff.client = path.client;
        try {
            StringTokenizer toker = new StringTokenizer(line);
            ff.date = FtpFile.examineWinListDate(toker.nextToken(), toker.nextToken());
            String size2dir = toker.nextToken();
            if (size2dir.equals("<DIR>")) {
                ff.access = "d?????????";
                ff.size = -1L;
            } else {
                ff.access = "-?????????";
                ff.size = Long.parseLong(size2dir);
            }
            String name = toker.nextToken("").trim();
            ff.owner = "";
            ff.group = "";
            ff.path = path.toString();
            ff.path = !ff.path.endsWith("/") ? ff.path + '/' + name : ff.path + name;
            ff.sortSetup(name);
        }
        catch (NumberFormatException e) {
            throw new NoSuchElementException("Win-List: Invalid Number Format");
        }
        if (ff.getName().compareTo(".") == 0 || ff.getName().compareTo("..") == 0) {
            throw new NoSuchElementException("skip");
        }
        return ff;
    }

    private static long examineWinListDate(String date, String time) {
        Calendar c = Calendar.getInstance();
        try {
            StringTokenizer toker = new StringTokenizer(date, "-");
            int m = Integer.parseInt(toker.nextToken()) - 1;
            int d = Integer.parseInt(toker.nextToken());
            int y = Integer.parseInt(toker.nextToken());
            y = y >= 70 ? (y += 1900) : (y += 2000);
            toker = new StringTokenizer(time, ":APM");
            c.set(y, m, d, (time.endsWith("PM") ? 12 : 0) + Integer.parseInt(toker.nextToken()), Integer.parseInt(toker.nextToken()));
        }
        catch (NumberFormatException e) {
            throw new NoSuchElementException("Win-List: Invalid Date Format");
        }
        return c.getTime().getTime();
    }

    private static FtpFile examineUnixListLine(FtpFile path, String line) throws NoSuchElementException {
        FtpFile ff = new FtpFile();
        ff.client = path.client;
        try {
            if (line.indexOf("->") >= 0) {
                line = line.substring(0, line.indexOf("->"));
            }
            StringTokenizer toker = new StringTokenizer(line);
            ff.access = toker.nextToken();
            toker.nextToken();
            ff.owner = toker.nextToken();
            ff.group = toker.nextToken();
            String size = toker.nextToken();
            if (size.endsWith(",")) {
                size = size.substring(0, size.indexOf(","));
            }
            String uu = size;
            if (ff.access.startsWith("c")) {
                uu = toker.nextToken();
            }
            if ("0123456789".indexOf(uu.charAt(0)) < 0) {
                size = ff.group;
                ff.group = "";
            }
            ff.size = Integer.parseInt(size);
            ff.date = FtpFile.examineUnixListDate("0123456789".indexOf(uu.charAt(0)) < 0 ? uu : toker.nextToken(), toker.nextToken(), toker.nextToken());
            String name = toker.nextToken("").trim();
            ff.path = path.toString();
            ff.path = !ff.path.endsWith("/") ? ff.path + '/' + name : ff.path + name;
            ff.sortSetup(name);
        }
        catch (NumberFormatException e) {
            throw new NoSuchElementException("Unix-List: Invalid Number Format");
        }
        catch (NoSuchElementException e) {
            try {
                StringTokenizer toker = new StringTokenizer(line);
                if (!toker.nextToken().equals("total")) {
                    throw e;
                }
                Long.parseLong(toker.nextToken());
                if (!toker.hasMoreTokens()) {
                    throw new NoSuchElementException("skip");
                }
                throw e;
            }
            catch (NumberFormatException x) {
                throw e;
            }
        }
        if (ff.getName().compareTo(".") == 0 || ff.getName().compareTo("..") == 0) {
            throw new NoSuchElementException("skip");
        }
        return ff;
    }

    private static long examineUnixListDate(String month, String day, String year2time) {
        Calendar c = Calendar.getInstance();
        month = month.toUpperCase();
        try {
            for (int m = 0; m < 12; ++m) {
                if (!month.equals(months[m])) continue;
                if (year2time.indexOf(58) != -1) {
                    c.setTime(new Date(System.currentTimeMillis()));
                    StringTokenizer toker = new StringTokenizer(year2time, ":");
                    c.set(c.get(1), m, Integer.parseInt(day), Integer.parseInt(toker.nextToken()), Integer.parseInt(toker.nextToken()));
                } else {
                    c.set(Integer.parseInt(year2time), m, Integer.parseInt(day), 0, 0);
                }
                break;
            }
        }
        catch (NumberFormatException e) {
            throw new NoSuchElementException("Unix-List: Invalid Date Format");
        }
        return c.getTime().getTime();
    }

    public String toString() {
        return this.getAbsolutePath();
    }
}

