/*
 * Decompiled with CFR 0.152.
 */
package cz.dhl.ftp;

import cz.dhl.ftp.Ftp;
import cz.dhl.ftp.FtpContext;
import cz.dhl.ftp.FtpControlSocket;
import cz.dhl.ftp.FtpInterpret;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

final class FtpDataSocket {
    private ServerSocket dataserver = null;
    private Socket data = null;
    FtpContext context = null;
    private FtpControlSocket control = null;

    FtpDataSocket(Ftp client) throws IOException {
        if (!client.isConnected()) {
            throw new IOException("Data: CreateSocket, No Connection!");
        }
        this.control = client.control;
        this.context = client.getContext();
    }

    String getConnect(String reply) throws NumberFormatException {
        if (reply == null) {
            throw new NumberFormatException("Null Reply!\n");
        }
        int begin = reply.indexOf(40);
        int end = reply.indexOf(41);
        if (begin != -1 && end != -1 && begin < end) {
            return reply.substring(begin + 1, end);
        }
        throw new NumberFormatException("Invalid Reply!\n" + reply);
    }

    String getConnectAddress(String connect) throws NumberFormatException {
        int s4 = -1;
        for (int i = 0; i < 4; ++i) {
            if ((s4 = connect.indexOf(44, s4 + 1)) != -1) continue;
            throw new NumberFormatException("Misformated Reply! " + i + ":" + s4 + " " + connect);
        }
        return connect.substring(0, s4).replace(',', '.');
    }

    int getConnectPort(String connect) throws NumberFormatException, NoSuchElementException {
        int s4 = -1;
        for (int i = 0; i < 4; ++i) {
            if ((s4 = connect.indexOf(44, s4 + 1)) != -1) continue;
            throw new NumberFormatException("Misformated Reply! " + i + ":" + s4 + " " + connect);
        }
        StringTokenizer tokenizer = new StringTokenizer(connect.substring(s4 + 1), ",");
        return Integer.parseInt(tokenizer.nextToken()) * 256 + Integer.parseInt(tokenizer.nextToken());
    }

    void openPassiveDataSocket(String commandline, char type) throws IOException {
        block8: {
            if (this.control.isConnected()) {
                try {
                    this.control.executeCommand("TYPE " + type);
                    this.control.executeCommand("PASV");
                    String connect = this.getConnect(this.control.replyOfCommand());
                    String address = this.getConnectAddress(connect);
                    int port = this.getConnectPort(connect);
                    this.data = new Socket(address, port);
                    this.data.setSoTimeout(60000);
                    if (!this.control.executeCommand(commandline)) {
                        throw new IOException(this.control.replyOfCommand());
                    }
                    break block8;
                }
                catch (NoSuchElementException e) {
                    throw new IOException("Data: OpenSocket, Invalid Format!\n" + e);
                }
                catch (NumberFormatException e) {
                    throw new IOException("Data: OpenSocket, Invalid Format!\n" + e);
                }
                catch (SocketException e) {
                    throw new IOException("Data: OpenSocket, Socket Error!\n" + e);
                }
                catch (IOException e) {
                    throw new IOException("Data: OpenSocket, IO Error!\n" + e);
                }
                catch (Exception e) {
                    throw new IOException("Data: OpenSocket, Permission Denied?\n" + e);
                }
            }
            throw new IOException("Data: OpenSocket, No Connection!");
        }
    }

    String getConnect() throws UnknownHostException {
        short port = (short)this.dataserver.getLocalPort();
        return InetAddress.getLocalHost().getHostAddress().replace('.', ',') + "," + port / 256 + "," + port % 256;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void openActiveDataSocket(String commandline, char type) throws IOException {
        block9: {
            if (this.control.isConnected()) {
                try {
                    this.control.executeCommand("TYPE " + type);
                    this.dataserver = new ServerSocket(0);
                    this.dataserver.setSoTimeout(20000);
                    this.control.executeCommand("PORT " + this.getConnect());
                    FtpControlSocket ftpControlSocket = this.control;
                    synchronized (ftpControlSocket) {
                        this.control.writeCommand(commandline);
                        this.data = this.dataserver.accept();
                        this.data.setSoTimeout(60000);
                        if (!this.control.completeCommand(FtpInterpret.getReplies(commandline))) {
                            throw new IOException(this.control.replyOfCommand());
                        }
                        break block9;
                    }
                }
                catch (SocketException e) {
                    throw new IOException("Data: OpenSocket, Socket Error!\n" + e);
                }
                catch (IOException e) {
                    throw new IOException("Data: OpenSocket, IO Error!\n" + e);
                }
                catch (Exception e) {
                    throw new IOException("Data: OpenSocket, Permission Denied!\n" + e);
                }
            }
            throw new IOException("Data: OpenSocket, No Connection!");
        }
    }

    void openDataSocket(String commandline, char type) throws IOException {
        if (this.context.getActiveSocketMode()) {
            this.openActiveDataSocket(commandline, type);
        } else {
            this.openPassiveDataSocket(commandline, type);
        }
    }

    InputStream getInputStream(String commandline, char type) throws IOException {
        if (this.data == null) {
            this.openDataSocket(commandline, type);
        }
        return this.data.getInputStream();
    }

    OutputStream getOutputStream(String commandline, char type) throws IOException {
        if (this.data == null) {
            this.openDataSocket(commandline, type);
        }
        return this.data.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void close() throws IOException {
        block9: {
            try {
                if (this.data != null) {
                    this.data.close();
                }
                Object var2_1 = null;
                this.data = null;
                if (!this.control.isConnected()) throw new IOException("Data: CloseSocket, No Connection!");
                if (this.control.completeCommand(FtpInterpret.getReplies("data-done"))) break block9;
                this.control.executeCommand("ABOR");
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.data = null;
                if (!this.control.isConnected()) throw new IOException("Data: CloseSocket, No Connection!");
                if (!this.control.completeCommand(FtpInterpret.getReplies("data-done"))) {
                    this.control.executeCommand("ABOR");
                    throw new IOException("Data: CloseSocket, Transfer Aborted!");
                }
                try {
                    if (this.dataserver == null) throw throwable;
                    this.dataserver.close();
                    throw throwable;
                }
                finally {
                    this.dataserver = null;
                }
            }
            throw new IOException("Data: CloseSocket, Transfer Aborted!");
        }
        try {
            if (this.dataserver == null) return;
            this.dataserver.close();
            return;
        }
        finally {
            this.dataserver = null;
        }
    }
}

