/*
 * Decompiled with CFR 0.152.
 */
package cz.dhl.ftp;

import cz.dhl.ftp.FtpContext;
import cz.dhl.ftp.FtpInterpret;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

final class FtpControlSocket {
    private Socket control = null;
    private BufferedReader in = null;
    private BufferedWriter out = null;
    private FtpContext context = null;
    private String replyline = null;
    String server = null;

    FtpControlSocket(FtpContext context) {
        this.context = context;
    }

    synchronized boolean connect(String server, int port) {
        boolean done = false;
        if (this.control == null) {
            try {
                this.context.printlog("Getting host by name: " + server);
                InetAddress addr = InetAddress.getByName(server);
                this.context.printlog("Connecting to host: " + addr.getHostAddress());
                this.control = new Socket(addr, port);
                this.control.setSoTimeout(60000);
                this.in = new BufferedReader(new InputStreamReader(this.control.getInputStream()));
                this.out = new BufferedWriter(new OutputStreamWriter(this.control.getOutputStream()));
                this.server = server;
                done = true;
            }
            catch (UnknownHostException e) {
                this.context.printlog("< Ctrl: Can't resolve host address! >");
            }
            catch (IOException e) {
                this.disconnect();
                this.context.printlog("< Ctrl: Can't obtain connection to host! >");
            }
            catch (Exception e) {
                this.context.printlog("< Ctrl: Permission denied! >");
            }
        }
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void disconnect() {
        while (this.in != null || this.out != null) {
            try {
                if (this.in != null) {
                    BufferedReader r = this.in;
                    this.in = null;
                    ((Reader)r).close();
                }
                if (this.out == null) continue;
                BufferedWriter w = this.out;
                this.out = null;
                ((Writer)w).close();
            }
            catch (IOException e) {
                this.context.printerr(e);
            }
        }
        if (this.control != null) {
            try {
                this.control.close();
            }
            catch (IOException e) {
                this.context.printerr(e);
            }
            finally {
                this.control = null;
                this.context.printlog("< Ctrl: Disconnected! >");
            }
        }
        this.server = null;
    }

    private synchronized void writeLine(String line) throws IOException {
        if (this.out != null) {
            try {
                this.out.write(line + "\r\n");
                this.out.flush();
            }
            catch (IOException e) {
                throw new IOException("Ctrl: Write, failed!\n" + e);
            }
        } else {
            throw new IOException("Ctrl: Write, No connection!");
        }
    }

    private synchronized String readLine() throws IOException {
        String line = null;
        if (this.in != null) {
            try {
                line = this.in.readLine();
            }
            catch (IOException e) {
                throw new IOException("Ctrl: Read, Error!\n" + e);
            }
            if (line == null) {
                this.disconnect();
                throw new IOException("Ctrl: Read, End Of File!");
            }
        } else {
            throw new IOException("Ctrl: Read, No connection!");
        }
        return line;
    }

    private synchronized String readReply() throws IOException {
        String line = null;
        do {
            line = this.readLine();
            this.context.printlog(line);
        } while (line.length() == 0 || line.indexOf("-") == 3 || "0123456789".indexOf(line.charAt(0)) < 0);
        return line;
    }

    synchronized boolean manualCommand(String commandline) {
        if (!FtpInterpret.allowManualExecution(commandline)) {
            this.context.printlog("< Ctrl: Command, No Manual Execution! >");
            return false;
        }
        return this.executeCommand(commandline);
    }

    synchronized boolean executeCommand(String commandline) {
        if (this.writeCommand(commandline)) {
            return this.completeCommand(FtpInterpret.getReplies(commandline));
        }
        return false;
    }

    synchronized boolean writeCommand(String commandline) {
        if (commandline.startsWith("PASS")) {
            this.context.printlog("Ftp> PASS ******");
        } else {
            this.context.printlog("Ftp> " + commandline);
        }
        if (!FtpInterpret.allowExecution(commandline)) {
            this.context.printlog("< Ctrl: Command, Not Implemented! >");
            return false;
        }
        boolean done = true;
        try {
            this.replyline = null;
            this.writeLine(commandline.trim());
        }
        catch (IOException e) {
            done = false;
            if (e.getMessage() != null) {
                this.context.printlog("< " + e.getMessage() + " >");
            }
            this.context.printerr(e);
        }
        return done;
    }

    synchronized boolean completeCommand(String[] replies) {
        boolean done = false;
        try {
            this.replyline = this.readReply();
            done = FtpInterpret.startsWith(this.replyline, replies);
        }
        catch (IOException e) {
            if (e.getMessage() != null) {
                this.context.printlog("< " + e.getMessage() + " >");
            }
            this.context.printerr(e);
        }
        return done;
    }

    String replyOfCommand() throws IOException {
        if (this.replyline != null) {
            return this.replyline;
        }
        throw new IOException("Ctrl: No Reply!");
    }

    boolean isConnected() {
        return this.control != null;
    }
}

