/*
 * Decompiled with CFR 0.152.
 */
package cz.dhl.ftp;

import cz.dhl.ftp.FtpConnect;
import cz.dhl.ftp.FtpContext;
import cz.dhl.ftp.FtpControlSocket;
import cz.dhl.ftp.FtpInterpret;
import cz.dhl.io.CoSource;
import java.io.IOException;

public final class Ftp
implements CoSource {
    public static final int PORT = 21;
    private FtpContext context = new FtpContext();
    FtpControlSocket control = new FtpControlSocket(this.context);

    public boolean connect(FtpConnect connect) throws IOException {
        if (this.connect(connect.getHostName(), connect.getPortNum())) {
            if (this.login(connect.getUserName(), connect.getPassWord())) {
                String pathname = connect.getPathName();
                if (connect.getPathName().length() > 0) {
                    this.cd(connect.getPathName());
                }
            } else {
                this.disconnect();
            }
        }
        return this.isConnected();
    }

    public boolean connect(String server, int port) throws IOException {
        if (!this.isConnected() && server != null) {
            if (this.control.connect(server, port)) {
                if (!this.control.completeCommand(FtpInterpret.getReplies("login-done"))) {
                    this.printlog("< Can't obtain welcome message from host! >");
                    this.control.disconnect();
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void disconnect() {
        this.control.disconnect();
    }

    public void abort() {
        this.disconnect();
    }

    public boolean login(String username, String password) throws IOException {
        if (this.control.executeCommand("USER " + username)) {
            if (this.control.executeCommand("PASS " + password)) {
                this.syst();
                return true;
            }
            this.printlog("< Can't login to host. >");
            return false;
        }
        this.printlog("< Can't login to host. >");
        return false;
    }

    public String host() throws IOException {
        if (this.isConnected()) {
            return this.control.server;
        }
        throw new IOException("Ctrl: No Connection!");
    }

    public boolean command(String commandline) {
        return this.control.manualCommand(commandline);
    }

    public boolean rmdir(String directory) {
        return this.control.executeCommand("RMD " + directory);
    }

    public boolean mkdir(String directory) {
        return this.control.executeCommand("MKD " + directory);
    }

    public String pwd() throws IOException {
        if (this.isConnected()) {
            String directory = null;
            this.control.executeCommand("PWD");
            String replyline = this.control.replyOfCommand();
            try {
                directory = replyline.substring(replyline.indexOf(34) + 1, replyline.lastIndexOf(34));
            }
            catch (StringIndexOutOfBoundsException e) {
                throw new IOException("Ctrl: PWD, Invalid Format!");
            }
            return directory;
        }
        throw new IOException("Ctrl: PWD, No Connection!");
    }

    public String syst() throws IOException {
        if (this.isConnected()) {
            this.control.executeCommand("SYST");
            String system = this.control.replyOfCommand();
            this.getContext().setServerSystemMode(1);
            if (system != null && system.toUpperCase().indexOf("WINDOWS") >= 0) {
                this.getContext().setServerSystemMode(2);
                this.printlog("< File: Setting 'WIN' Server Mode >");
            }
            return system;
        }
        throw new IOException("Ctrl: PWD, No Connection!");
    }

    public boolean cd(String directory) {
        return this.control.executeCommand("CWD " + directory);
    }

    public boolean cdup() {
        return this.control.executeCommand("CDUP");
    }

    public boolean rm(String filename) {
        return this.control.executeCommand("DELE " + filename);
    }

    public boolean mv(String oldfilename, String newfilename) {
        if (this.control.executeCommand("RNFR " + oldfilename)) {
            return this.control.executeCommand("RNTO " + newfilename);
        }
        return false;
    }

    public boolean chmod(String filename, String mode) {
        return this.control.executeCommand("SITE CHMOD " + mode + " " + filename);
    }

    public boolean isConnected() {
        return this.control.isConnected();
    }

    public FtpContext getContext() {
        return this.context;
    }

    void printlog(String message) {
        this.context.printlog(message);
    }

    void printerr(Exception exception) {
        this.context.printerr(exception);
    }
}

